/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.topology;

import dmg.cells.network.CellDomainNode;
import dmg.util.Args;
import org.dcache.cells.CellCommandListener;
import org.dcache.services.topology.CellsTopology;
import org.dcache.services.topology.HostnameService;

public class CellsTopologyInterpreter
implements CellCommandListener {
    private CellsTopology _topology;
    private HostnameService _hostnameService;
    public static final String hh_ls = "[-l] # list available domains";
    public static final String hh_gettopomap = "# provides topology map in binary form";
    public static final String hh_getallhostnames = "# returns a complete list of all hosts running a domain of this dCache instance. Run updatehostnames first to get uptodate values";
    public static final String hh_updatehostnames = "# starts background thread to retrieveall hostnames of hosts hosting a dCache domain";

    public void setCellsTopology(CellsTopology topology) {
        this._topology = topology;
    }

    public void setHostnameService(HostnameService hostnameService) {
        this._hostnameService = hostnameService;
    }

    public String ac_ls_$_0(Args args) {
        boolean detail = args.hasOption("l");
        CellDomainNode[] info = this._topology.getInfoMap();
        if (info == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CellDomainNode node : info) {
            sb.append(node.getName());
            if (detail) {
                sb.append(" ").append(node.getAddress());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Object ac_gettopomap(Args args) {
        return this._topology.getInfoMap();
    }

    public String ac_getallhostnames(Args args) {
        return this._hostnameService.getHostnames();
    }

    public String ac_updatehostnames(Args args) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                CellsTopologyInterpreter.this._hostnameService.updateHostnames();
            }
        };
        thread.start();
        return "Hostname update started";
    }
}

