/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.topology;

import diskCacheV111.util.SpreadAndWait;
import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcache.cells.CellMessageSender;
import org.dcache.services.topology.CellsTopology;
import org.dcache.services.topology.HostnameService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellsHostnameService
implements HostnameService,
CellMessageSender {
    private long _timeout;
    private CellEndpoint _endpoint;
    private CellsTopology _topology;
    private Set<String> _hostnames = new HashSet<String>();
    private static final Logger _log = LoggerFactory.getLogger(CellsHostnameService.class);

    @Override
    public synchronized String getHostnames() {
        return this._hostnames.toString();
    }

    @Override
    public void updateHostnames() {
        CellDomainNode[] info = this._topology.getInfoMap();
        if (info == null) {
            _log.info("Cannot update Hostnames. Domains not known yet. Try running update first");
            return;
        }
        _log.info("Hostnames update started");
        SpreadAndWait spreader = new SpreadAndWait(this._endpoint, this._timeout);
        for (CellDomainNode domain : info) {
            spreader.send(this.createMessage(domain.getAddress()));
        }
        try {
            spreader.waitForReplies();
            this.buildHostnameList(spreader.getReplyList());
            _log.info("Hostnames update finished");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHostnameList(List<CellMessage> replyList) {
        HashSet<String> hostnames = new HashSet<String>();
        for (CellMessage msg : replyList) {
            hostnames.add((String)((Object)msg.getMessageObject()));
        }
        CellsHostnameService cellsHostnameService = this;
        synchronized (cellsHostnameService) {
            this._hostnames = hostnames;
        }
    }

    private CellMessage createMessage(String cellPath) {
        CellMessage message = new CellMessage(new CellPath(cellPath), (Serializable)((Object)"get hostname"));
        return message;
    }

    public void setTopology(CellsTopology topology) {
        this._topology = topology;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        this._endpoint = endpoint;
    }
}

