/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.login;

import diskCacheV111.util.CacheException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.cells.CellStub;
import org.dcache.services.login.LoginMessage;
import org.dcache.services.login.MapMessage;
import org.dcache.services.login.ReverseMapMessage;
import org.springframework.beans.factory.annotation.Required;

public class RemoteLoginStrategy
implements LoginStrategy {
    private CellStub _stub;

    public RemoteLoginStrategy() {
    }

    public RemoteLoginStrategy(CellStub stub) {
        this.setCellStub(stub);
    }

    @Required
    public void setCellStub(CellStub stub) {
        if (stub == null) {
            throw new NullPointerException();
        }
        this._stub = stub;
    }

    public CellStub getCellStub() {
        return this._stub;
    }

    @Override
    public LoginReply login(Subject subject) throws CacheException {
        if (this._stub == null) {
            throw new IllegalStateException("CellStub is not set");
        }
        try {
            LoginMessage message = this._stub.sendAndWait(new LoginMessage(subject));
            return new LoginReply(message.getSubject(), message.getLoginAttributes());
        }
        catch (CacheException e) {
            if (e.getRc() == 10015) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw new CacheException("Login failed because the operation was interrupted");
        }
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        if (this._stub == null) {
            throw new IllegalStateException("CellStub is not set");
        }
        try {
            return this._stub.sendAndWait(new MapMessage(principal)).getMappedPrincipal();
        }
        catch (InterruptedException e) {
            throw new CacheException("Login failed because the operation was interrupted");
        }
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        if (this._stub == null) {
            throw new IllegalStateException("CellStub is not set");
        }
        try {
            return this._stub.sendAndWait(new ReverseMapMessage(principal)).getMappedPrincipals();
        }
        catch (InterruptedException e) {
            throw new CacheException("Login failed because the operation was interrupted");
        }
    }
}

