/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.login;

import diskCacheV111.util.CacheException;
import dmg.util.Args;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.List;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Subjects;
import org.dcache.auth.UidPrincipal;
import org.dcache.cells.CellCommandListener;

public class LoginCLI
implements CellCommandListener {
    private LoginStrategy _loginStrategy;
    public static final String fh_test_login = "This command simulates an attempt to login with a particular set of\nprincipals, as extracted by a door.  The result of the login is shown:\neither the login succeeds or fails.  If the login succeeds then the set\nof identities is shown.\n\nEach supplied principal has the form <type>:<value> (e.g. 'name:paul').\nIf a principal has spaces then surround the declaration with quote-marks\n(e.g., \"dn:/C=DE/O=ACME/CN=Example certificate\").\n\nValid principal types are:\n\n    name      a user-requested username\n    kerberos  a kerberos principal (e.g. paul@EXAMPLE.ORG)\n    dn        the distinguished name from an X509 certificate\n    fqan      an FQAN, the first is taken as the primary FQAN\n";
    public static final String hh_test_login = "<principal> [<principal> ...] # show result of login";
    public static final String fh_get_identity = "get identity <principal> <type>\nGet identity for provided principal.\nExample:   get identity atlas01 UserNamePrincipal";
    public static final String hh_get_identity = "<principal> <type>";
    public static final String fh_get_ridentity = "get ridentity -group <pringipal>\n\nGet reverse identity mapping for provided id.  -group  provided id represents a group id.\nExample:  get ridentity -group 100";
    public static final String hh_get_ridentity = "<principal>";
    private static final String PREFIX = "org.dcache.auth.";

    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }

    public LoginStrategy getLoginStrategy() {
        return this._loginStrategy;
    }

    public String ac_test_login_$_1_99(Args args) {
        Subject subject = Subjects.subjectFromArgs((List)args.getArguments());
        try {
            LoginReply reply = this._loginStrategy.login(subject);
            return reply.toString();
        }
        catch (CacheException e) {
            return e.toString();
        }
    }

    public String ac_get_identity_$_2(Args args) throws Exception {
        String name = args.argv(0);
        String type = args.argv(1);
        Principal p = this._loginStrategy.map(this.principalOf(type, name));
        if (p != null) {
            return p.getName();
        }
        return "No mapping for specified principal found.";
    }

    public String ac_get_ridentity_$_1(Args args) throws CacheException {
        String id = args.argv(0);
        boolean isGroup = args.hasOption("group");
        Object principal = isGroup ? new GidPrincipal(id, false) : new UidPrincipal(id);
        return this._loginStrategy.reverseMap((Principal)principal).toString();
    }

    private Principal principalOf(String type, String name) throws Exception {
        Class<Principal> c;
        try {
            c = Class.forName(type).asSubclass(Principal.class);
        }
        catch (ClassNotFoundException e) {
            c = Class.forName(PREFIX + type).asSubclass(Principal.class);
        }
        Constructor<Principal> constructor = c.getConstructor(String.class);
        return constructor.newInstance(name);
    }
}

