/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.login;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import diskCacheV111.util.CacheException;
import dmg.util.Args;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.cells.CellCommandListener;

public class CachingLoginStrategy
implements LoginStrategy,
CellCommandListener {
    private final LoginStrategy _inner;
    private final LoadingCache<Principal, CheckedFuture<Principal, CacheException>> _forwardCache;
    private final LoadingCache<Principal, CheckedFuture<Set<Principal>, CacheException>> _reverseCache;
    private final LoadingCache<Subject, CheckedFuture<LoginReply, CacheException>> _loginCache;
    private final long _time;
    private final TimeUnit _unit;
    private final int _size;
    public static final String hh_login_clear_cache = " # clear cached result of login and identity mapping oprations";
    public static final String hh_login_dump_cache = " # dump cached result of login and identity mapping oprations";

    public CachingLoginStrategy(LoginStrategy inner, int size, long timeout, TimeUnit unit) {
        this._inner = inner;
        this._forwardCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, unit).maximumSize((long)size).softValues().build((CacheLoader)new ForwardFetcher());
        this._reverseCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, unit).maximumSize((long)size).softValues().build((CacheLoader)new ReverseFetcher());
        this._loginCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, unit).maximumSize((long)size).softValues().build((CacheLoader)new LoginFetcher());
        this._time = timeout;
        this._unit = unit;
        this._size = size;
    }

    @Override
    public LoginReply login(Subject subject) throws CacheException {
        return (LoginReply)((CheckedFuture)this._loginCache.getUnchecked((Object)subject)).checkedGet();
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        return (Principal)((CheckedFuture)this._forwardCache.getUnchecked((Object)principal)).checkedGet();
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        return (Set)((CheckedFuture)this._reverseCache.getUnchecked((Object)principal)).checkedGet();
    }

    public String ac_login_clear_cache(Args args) {
        this._forwardCache.invalidateAll();
        this._loginCache.invalidateAll();
        this._reverseCache.invalidateAll();
        return "";
    }

    public String ac_login_dump_cache(Args args) {
        CheckedFuture out;
        StringBuilder sb = new StringBuilder();
        sb.append("Max Cache size: ").append(this._size).append("\n");
        sb.append("Max Cache time: ").append(this._time).append(" ").append(this._unit.name().toLowerCase()).append("\n");
        sb.append("Login:\n");
        for (Subject s : this._loginCache.asMap().keySet()) {
            try {
                out = (CheckedFuture)this._loginCache.getIfPresent((Object)s);
                if (out == null) continue;
                sb.append("   ").append(s.getPrincipals()).append(" => ");
                sb.append(out.checkedGet()).append('\n');
            }
            catch (CacheException e) {
                sb.append(e.toString()).append('\n');
            }
        }
        sb.append("Map:\n");
        for (Principal p : this._forwardCache.asMap().keySet()) {
            try {
                out = (CheckedFuture)this._forwardCache.getIfPresent((Object)p);
                if (out == null) continue;
                sb.append("   ").append(p).append(" => ");
                sb.append(out.checkedGet()).append('\n');
            }
            catch (CacheException e) {
                sb.append(e.toString()).append('\n');
            }
        }
        sb.append("ReverseMap:\n");
        for (Principal p : this._reverseCache.asMap().keySet()) {
            try {
                out = (CheckedFuture)this._reverseCache.getIfPresent((Object)p);
                if (out == null) continue;
                sb.append("   ").append(p).append(" => ");
                sb.append(out.checkedGet()).append('\n');
            }
            catch (CacheException e) {
                sb.append(e.toString()).append('\n');
            }
        }
        return sb.toString();
    }

    private class LoginFetcher
    extends CacheLoader<Subject, CheckedFuture<LoginReply, CacheException>> {
        private LoginFetcher() {
        }

        public CheckedFuture<LoginReply, CacheException> load(Subject f) {
            try {
                LoginReply s = CachingLoginStrategy.this._inner.login(f);
                return Futures.immediateCheckedFuture((Object)s);
            }
            catch (CacheException e) {
                return Futures.immediateFailedCheckedFuture((Exception)e);
            }
        }
    }

    private class ReverseFetcher
    extends CacheLoader<Principal, CheckedFuture<Set<Principal>, CacheException>> {
        private ReverseFetcher() {
        }

        public CheckedFuture<Set<Principal>, CacheException> load(Principal f) {
            try {
                Set<Principal> s = CachingLoginStrategy.this._inner.reverseMap(f);
                return Futures.immediateCheckedFuture(s);
            }
            catch (CacheException e) {
                return Futures.immediateFailedCheckedFuture((Exception)e);
            }
        }
    }

    private class ForwardFetcher
    extends CacheLoader<Principal, CheckedFuture<Principal, CacheException>> {
        private ForwardFetcher() {
        }

        public CheckedFuture<Principal, CacheException> load(Principal f) {
            try {
                Principal p = CachingLoginStrategy.this._inner.map(f);
                return Futures.immediateCheckedFuture((Object)p);
            }
            catch (CacheException e) {
                return Futures.immediateFailedCheckedFuture((Exception)e);
            }
        }
    }
}

