/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.stateInfo.ReservationInfo;
import org.dcache.services.info.stateInfo.SkeletonListVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationInfoVisitor
extends SkeletonListVisitor {
    private static Logger _log = LoggerFactory.getLogger(ReservationInfoVisitor.class);
    public static final String PATH_ELEMENT_SPACE = "space";
    public static final String PATH_ELEMENT_LIFETIME = "lifetime";
    public static final String PATH_ELEMENT_TOTAL = "total";
    public static final String PATH_ELEMENT_FREE = "free";
    public static final String PATH_ELEMENT_ALLOCATED = "allocated";
    public static final String PATH_ELEMENT_USED = "used";
    public static final String PATH_ELEMENT_AL = "access-latency";
    public static final String PATH_ELEMENT_RP = "retention-policy";
    public static final String PATH_ELEMENT_STATE = "state";
    public static final String PATH_ELEMENT_DESCRIPTION = "description";
    public static final String PATH_ELEMENT_AUTHORISATION = "authorisation";
    public static final String PATH_ELEMENT_GROUP = "group";
    public static final StatePath RESERVATIONS_PATH = StatePath.parsePath("reservations");
    public static final Pattern VO_EXTRACTOR_PATTERN = Pattern.compile("^/?([^/]*).*");
    private final Map<String, ReservationInfo> _reservations = new HashMap<String, ReservationInfo>();
    private ReservationInfo _thisResv;
    private StatePath _thisResvPath;
    private StatePath _thisResvSpacePath;
    private StatePath _thisResvAuthPath;

    public static Map<String, ReservationInfo> getDetails(StateExhibitor exhibitor) {
        _log.debug("Gathering reservation information.");
        ReservationInfoVisitor visitor = new ReservationInfoVisitor();
        exhibitor.visitState(visitor);
        return visitor.getReservations();
    }

    public ReservationInfoVisitor() {
        super(RESERVATIONS_PATH);
    }

    public Map<String, ReservationInfo> getReservations() {
        return Collections.unmodifiableMap(this._reservations);
    }

    @Override
    protected void newListItem(String listItemName) {
        super.newListItem(listItemName);
        this._thisResv = new ReservationInfo(listItemName);
        this._reservations.put(listItemName, this._thisResv);
        this._thisResvPath = RESERVATIONS_PATH.newChild(listItemName);
        this._thisResvSpacePath = this._thisResvPath.newChild(PATH_ELEMENT_SPACE);
        this._thisResvAuthPath = this._thisResvPath.newChild(PATH_ELEMENT_AUTHORISATION);
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
        if (!this.isInListItem()) {
            return;
        }
        String metricName = path.getLastElement();
        if (this._thisResvPath.isParentOf(path)) {
            if (metricName.equals(PATH_ELEMENT_LIFETIME)) {
                this._thisResv.setLifetime(value.getValue());
            }
            return;
        }
        if (this._thisResvSpacePath.isParentOf(path)) {
            switch (metricName) {
                case "total": {
                    this._thisResv.setTotal(value.getValue());
                    break;
                }
                case "free": {
                    this._thisResv.setFree(value.getValue());
                    break;
                }
                case "allocated": {
                    this._thisResv.setAllocated(value.getValue());
                    break;
                }
                case "used": {
                    this._thisResv.setUsed(value.getValue());
                    break;
                }
                default: {
                    _log.warn("Seen unexpected reservation metric at path " + path);
                }
            }
        }
    }

    @Override
    public void visitString(StatePath path, StringStateValue value) {
        if (!this.isInListItem()) {
            return;
        }
        if (!(this._thisResvPath.isParentOf(path) || this._thisResvSpacePath.isParentOf(path) || this._thisResvAuthPath.isParentOf(path))) {
            return;
        }
        String metricName = path.getLastElement();
        if (metricName.equals(PATH_ELEMENT_AL)) {
            ReservationInfo.AccessLatency al = ReservationInfo.AccessLatency.parseMetricValue(value.toString());
            if (al != null) {
                this._thisResv.setAccessLatency(al);
            } else {
                _log.error("Unknown access-latency value " + value.toString());
            }
            return;
        }
        if (metricName.equals(PATH_ELEMENT_RP)) {
            ReservationInfo.RetentionPolicy rp = ReservationInfo.RetentionPolicy.parseMetricValue(value.toString());
            if (rp != null) {
                this._thisResv.setRetentionPolicy(rp);
            } else {
                _log.error("Unknown retention-policy value " + value.toString());
            }
            return;
        }
        if (metricName.equals(PATH_ELEMENT_STATE)) {
            ReservationInfo.State state = ReservationInfo.State.parseMetricValue(value.toString());
            if (state != null) {
                this._thisResv.setState(state);
            } else {
                _log.error("Unknown state value " + value.toString());
            }
            return;
        }
        if (metricName.equals(PATH_ELEMENT_DESCRIPTION)) {
            this._thisResv.setDescription(value.toString());
            return;
        }
        if (metricName.equals(PATH_ELEMENT_GROUP)) {
            Matcher matcher = VO_EXTRACTOR_PATTERN.matcher(value.toString());
            if (matcher.matches()) {
                String voName = matcher.group(1);
                this._thisResv.setVo(voName);
            } else {
                _log.error("authorisation.group doesn't match expected pattern " + value.toString());
            }
        }
    }
}

