/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.BooleanStateValue;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StateGuide;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateVisitor;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.base.guides.SubtreeStateGuide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolgroupToPoolsVisitor
implements StateVisitor {
    private static Logger _log = LoggerFactory.getLogger(PoolgroupToPoolsVisitor.class);
    private static final StatePath POOLGROUPS_PATH = new StatePath("poolgroups");
    Map<String, Set<String>> _poolgroups = new HashMap<String, Set<String>>();
    Set<String> _currentPoolgroupPools;
    StatePath _poolMembershipPath;
    StateGuide _guide = new SubtreeStateGuide(POOLGROUPS_PATH);

    public static Map<String, Set<String>> getDetails(StateExhibitor exhibitor) {
        if (_log.isInfoEnabled()) {
            _log.info("Gathering current status");
        }
        PoolgroupToPoolsVisitor visitor = new PoolgroupToPoolsVisitor();
        exhibitor.visitState(visitor);
        return visitor._poolgroups;
    }

    @Override
    public boolean isVisitable(StatePath path) {
        return this._guide.isVisitable(path);
    }

    @Override
    public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
        if (_log.isDebugEnabled()) {
            _log.debug("Examining " + path);
        }
        if (POOLGROUPS_PATH.isParentOf(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Found poolgroup " + path.getLastElement());
            }
            this._currentPoolgroupPools = new HashSet<String>();
            this._poolgroups.put(path.getLastElement(), this._currentPoolgroupPools);
            this._poolMembershipPath = path.newChild("pools");
        }
        if (this._poolMembershipPath != null && this._poolMembershipPath.isParentOf(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Found pool " + path.getLastElement());
            }
            this._currentPoolgroupPools.add(path.getLastElement());
        }
    }

    @Override
    public void visitCompositePostDescend(StatePath path, Map<String, String> metadata) {
    }

    @Override
    public void visitString(StatePath path, StringStateValue value) {
    }

    @Override
    public void visitBoolean(StatePath path, BooleanStateValue value) {
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
    }

    @Override
    public void visitFloatingPoint(StatePath path, FloatingPointStateValue value) {
    }
}

