/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.stateInfo.LinkInfo;
import org.dcache.services.info.stateInfo.SkeletonListVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkInfoVisitor
extends SkeletonListVisitor {
    private static Logger _log = LoggerFactory.getLogger(LinkInfoVisitor.class);
    private static final StatePath LINK_PATH = StatePath.parsePath("links");
    private static final String LINK_POOLS_PATH_ELEMENT = "pools";
    private static final String LINK_POOLGROUPS_PATH_ELEMENT = "poolgroups";
    private static final String LINK_UNITGROUPS_PATH_ELEMENT = "unitgroups";
    private static final String LINK_UNITS_PATH_ELEMENT = "units";
    private static final String LINK_SPACE_PATH_ELEMENT = "space";
    private static final String LINK_STORE_PATH_ELEMENT = "store";
    private static final String LINK_NET_PATH_ELEMENT = "net";
    private static final String LINK_PROTO_PATH_ELEMENT = "protocol";
    private static final String LINK_DCACHE_PATH_ELEMENT = "dcache";
    private static final String LINK_PREFS_PATH_ELEMENT = "prefs";
    private static final String LINK_READ_METRIC_PATH_ELEMENT = "read";
    private static final String LINK_WRITE_METRIC_PATH_ELEMENT = "write";
    private static final String LINK_CACHE_METRIC_PATH_ELEMENT = "cache";
    private static final String LINK_P2P_METRIC_PATH_ELEMENT = "p2p";
    public static final Map<String, LinkInfo.UNIT_TYPE> UNIT_TYPE_NAMES = Collections.unmodifiableMap(new HashMap<String, LinkInfo.UNIT_TYPE>(){
        private static final long serialVersionUID = 4631442886053020941L;
        {
            this.put(LinkInfoVisitor.LINK_STORE_PATH_ELEMENT, LinkInfo.UNIT_TYPE.STORE);
            this.put(LinkInfoVisitor.LINK_NET_PATH_ELEMENT, LinkInfo.UNIT_TYPE.NETWORK);
            this.put(LinkInfoVisitor.LINK_DCACHE_PATH_ELEMENT, LinkInfo.UNIT_TYPE.DCACHE);
            this.put(LinkInfoVisitor.LINK_PROTO_PATH_ELEMENT, LinkInfo.UNIT_TYPE.PROTOCOL);
        }
    });
    public static final Map<String, LinkInfo.OPERATION> OPERATION_NAMES = Collections.unmodifiableMap(new HashMap<String, LinkInfo.OPERATION>(){
        private static final long serialVersionUID = 8199146124808181726L;
        {
            this.put(LinkInfoVisitor.LINK_READ_METRIC_PATH_ELEMENT, LinkInfo.OPERATION.READ);
            this.put(LinkInfoVisitor.LINK_WRITE_METRIC_PATH_ELEMENT, LinkInfo.OPERATION.WRITE);
            this.put(LinkInfoVisitor.LINK_CACHE_METRIC_PATH_ELEMENT, LinkInfo.OPERATION.CACHE);
            this.put(LinkInfoVisitor.LINK_P2P_METRIC_PATH_ELEMENT, LinkInfo.OPERATION.P2P);
        }
    });
    private final Map<String, LinkInfo> _links = new HashMap<String, LinkInfo>();
    private LinkInfo _thisLink;
    private StatePath _thisLinkPoolsPath;
    private StatePath _thisLinkPoolgroupPath;
    private StatePath _thisLinkUnitgroupsPath;
    private StatePath _thisLinkUnitsPath;
    private StatePath _thisLinkSpacePath;
    private StatePath _thisLinkOperationPrefPath;
    private StatePath _thisLinkPath;

    public static Map<String, LinkInfo> getDetails(StateExhibitor exhibitor) {
        _log.debug("Gathering link information.");
        LinkInfoVisitor visitor = new LinkInfoVisitor();
        exhibitor.visitState(visitor);
        return visitor.getInfo();
    }

    public LinkInfoVisitor() {
        super(LINK_PATH);
    }

    @Override
    protected void newListItem(String listItemName) {
        super.newListItem(listItemName);
        this._thisLink = new LinkInfo(listItemName);
        this._links.put(listItemName, this._thisLink);
        this._thisLinkPath = LINK_PATH.newChild(listItemName);
        this._thisLinkPoolsPath = this._thisLinkPath.newChild(LINK_POOLS_PATH_ELEMENT);
        this._thisLinkPoolgroupPath = this._thisLinkPath.newChild(LINK_POOLGROUPS_PATH_ELEMENT);
        this._thisLinkUnitgroupsPath = this._thisLinkPath.newChild(LINK_UNITGROUPS_PATH_ELEMENT);
        this._thisLinkUnitsPath = this._thisLinkPath.newChild(LINK_UNITS_PATH_ELEMENT);
        this._thisLinkSpacePath = this._thisLinkPath.newChild(LINK_SPACE_PATH_ELEMENT);
        this._thisLinkOperationPrefPath = this._thisLinkPath.newChild(LINK_PREFS_PATH_ELEMENT);
    }

    @Override
    public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
        super.visitCompositePreDescend(path, metadata);
        if (!this.isInListItem()) {
            return;
        }
        String listItem = path.getLastElement();
        if (this._thisLinkUnitsPath.equals(path) || this._thisLinkUnitsPath.isParentOf(path) && UNIT_TYPE_NAMES.containsKey(listItem)) {
            return;
        }
        if (this._thisLinkSpacePath.equals(path) || this._thisLinkSpacePath.isParentOf(path)) {
            return;
        }
        StatePath parentPath = path.parentPath();
        String parentLastElement = parentPath.getLastElement();
        if (this._thisLinkPath.equals(path) || this._thisLinkOperationPrefPath.equals(path) || this._thisLinkUnitsPath.equals(path) || this._thisLinkPoolsPath.equals(path) || this._thisLinkPoolgroupPath.equals(path) || this._thisLinkUnitgroupsPath.equals(path)) {
            return;
        }
        if (this._thisLinkUnitsPath.isParentOf(parentPath) && UNIT_TYPE_NAMES.containsKey(parentLastElement)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Adding pool " + listItem);
            }
            this._thisLink.addUnit(UNIT_TYPE_NAMES.get(parentLastElement), listItem);
            return;
        }
        if (this._thisLinkPoolsPath.isParentOf(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Adding pool " + listItem);
            }
            this._thisLink.addPool(listItem);
            return;
        }
        if (this._thisLinkPoolgroupPath.isParentOf(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Adding poolgroup " + listItem);
            }
            this._thisLink.addPoolgroup(listItem);
            return;
        }
        if (this._thisLinkUnitgroupsPath.isParentOf(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Adding unitgroup " + listItem);
            }
            this._thisLink.addUnitgroup(listItem);
            return;
        }
        _log.warn("Unexpected element at " + path);
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
        if (!this.isInListItem()) {
            return;
        }
        if (!this._thisLinkOperationPrefPath.isParentOf(path)) {
            return;
        }
        String metricName = path.getLastElement();
        if (OPERATION_NAMES.containsKey(metricName)) {
            this._thisLink.setOperationPref(OPERATION_NAMES.get(metricName), value.getValue());
        }
    }

    public Map<String, LinkInfo> getInfo() {
        return this._links;
    }

    public String debugInfo() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, LinkInfo> entry : this._links.entrySet()) {
            LinkInfo info = entry.getValue();
            sb.append(info.debugInfo());
            sb.append("\n");
        }
        return sb.toString();
    }
}

