/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.serialisation;

import org.dcache.services.info.base.StateGuide;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateVisitor;
import org.dcache.services.info.base.guides.SubtreeStateGuide;
import org.dcache.services.info.base.guides.VisitEverythingStateGuide;

public abstract class SubtreeVisitor
implements StateVisitor {
    private StateGuide _guide;

    public SubtreeVisitor() {
        this.setVisitScopeToEverything();
    }

    public SubtreeVisitor(StatePath subtreeRoot) {
        this.setVisitScopeToSubtree(subtreeRoot);
    }

    protected void setVisitScopeToEverything() {
        this._guide = new VisitEverythingStateGuide();
    }

    protected void setVisitScopeToSubtree(StatePath subtreeRoot) {
        this._guide = new SubtreeStateGuide(subtreeRoot);
    }

    @Override
    public boolean isVisitable(StatePath path) {
        return this._guide.isVisitable(path);
    }

    protected boolean isInsideScope(StatePath path) {
        if (this._guide instanceof SubtreeStateGuide) {
            SubtreeStateGuide ssg = (SubtreeStateGuide)this._guide;
            return ssg.isInSubtree(path);
        }
        return true;
    }
}

