/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.secondaryInfoProviders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.secondaryInfoProviders.AbstractStateWatcher;
import org.dcache.services.info.stateInfo.PoolSpaceVisitor;
import org.dcache.services.info.stateInfo.SetMapVisitor;
import org.dcache.services.info.stateInfo.SpaceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolgroupSpaceWatcher
extends AbstractStateWatcher {
    private static Logger _log = LoggerFactory.getLogger(PoolgroupSpaceWatcher.class);
    private static final String[] PREDICATE_PATHS = new String[]{"pools.*.space.*", "poolgroups.*", "poolgroups.*.pools.*"};
    private static final StatePath POOLGROUPS_PATH = new StatePath("poolgroups");
    private static final StatePath POOL_MEMBERSHIP_REL_PATH = new StatePath("pools");

    @Override
    protected String[] getPredicates() {
        return PREDICATE_PATHS;
    }

    @Override
    public void trigger(StateUpdate update, StateExhibitor currentState, StateExhibitor futureState) {
        super.trigger(update, currentState, futureState);
        HashSet<String> recalcPoolgroup = new HashSet<String>();
        if (_log.isInfoEnabled()) {
            _log.info("Watcher " + this.getClass().getSimpleName() + " triggered");
        }
        _log.debug("Gathering state:");
        _log.debug("  building current poolgroup membership.");
        Map<String, Set<String>> currentPoolgroupMembership = SetMapVisitor.getDetails(currentState, POOLGROUPS_PATH, POOL_MEMBERSHIP_REL_PATH);
        _log.debug("  building future poolgroup membership.");
        Map<String, Set<String>> futurePoolgroupMembership = SetMapVisitor.getDetails(futureState, POOLGROUPS_PATH, POOL_MEMBERSHIP_REL_PATH);
        _log.debug("  establishing current pool space mapping.");
        Map<String, SpaceInfo> poolSpaceInfoPre = PoolSpaceVisitor.getDetails(currentState);
        _log.debug("  establishing future pool space mapping.");
        Map<String, SpaceInfo> poolSpaceInfoPost = PoolSpaceVisitor.getDetails(futureState);
        _log.debug("Looking for changes in poolgroup membership.");
        this.updateTodoBasedOnMembership(recalcPoolgroup, currentPoolgroupMembership, futurePoolgroupMembership);
        _log.debug("Looking for changes in pool space information.");
        this.updateTodoBasedOnPoolSpace(recalcPoolgroup, futurePoolgroupMembership, poolSpaceInfoPre, poolSpaceInfoPost);
        if (recalcPoolgroup.size() == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug("No poolgroups need updating");
            }
            return;
        }
        for (String thisPoolgroup : recalcPoolgroup) {
            if (_log.isDebugEnabled()) {
                _log.debug("Updating poolgroup " + thisPoolgroup);
            }
            StatePath thisPgPath = POOLGROUPS_PATH.newChild(thisPoolgroup);
            this.buildNewMetrics(update, thisPgPath.newChild("space"), futurePoolgroupMembership.get(thisPoolgroup), poolSpaceInfoPost);
        }
    }

    private void buildNewMetrics(StateUpdate update, StatePath path, Set<String> pools, Map<String, SpaceInfo> poolsSpaceInfo) {
        SpaceInfo pgSpaceInfo = new SpaceInfo();
        update.appendUpdate(path, new StateComposite());
        if (pools != null) {
            for (String thisPool : pools) {
                SpaceInfo poolSpace = poolsSpaceInfo.get(thisPool);
                if (poolSpace == null) continue;
                pgSpaceInfo.add(poolSpace);
            }
        }
        pgSpaceInfo.addMetrics(update, path, false);
        if (_log.isDebugEnabled()) {
            _log.debug("  new info: " + pgSpaceInfo.toString());
        }
    }

    private void updateTodoBasedOnMembership(Set<String> recalcPoolgroup, Map<String, Set<String>> currentPoolgroupMembership, Map<String, Set<String>> futurePoolgroupMembership) {
        for (Map.Entry<String, Set<String>> pgEntry : futurePoolgroupMembership.entrySet()) {
            Set<String> thisPoolgroupCurrentPoolset;
            String thisPoolgroup = pgEntry.getKey();
            Set<String> thisPoolgroupFuturePoolset = pgEntry.getValue();
            if (_log.isDebugEnabled()) {
                _log.debug("  examining poolgroup: " + thisPoolgroup);
            }
            if ((thisPoolgroupCurrentPoolset = currentPoolgroupMembership.get(thisPoolgroup)) != null && thisPoolgroupCurrentPoolset.equals(thisPoolgroupFuturePoolset)) continue;
            recalcPoolgroup.add(thisPoolgroup);
            if (!_log.isDebugEnabled()) continue;
            _log.debug("    poolgroup " + thisPoolgroup + " is new or has altered membership");
            StringBuilder wasSb = new StringBuilder();
            if (thisPoolgroupCurrentPoolset != null) {
                for (String pool : thisPoolgroupCurrentPoolset) {
                    if (wasSb.length() > 0) {
                        wasSb.append(", ");
                    }
                    wasSb.append(pool);
                }
                if (wasSb.length() == 0) {
                    wasSb.append("<empty>");
                }
            } else {
                wasSb.append("<unknown>");
            }
            _log.debug("      was: " + wasSb.toString());
            StringBuilder nowSb = new StringBuilder();
            if (thisPoolgroupFuturePoolset != null) {
                for (String pool : thisPoolgroupFuturePoolset) {
                    if (nowSb.length() > 0) {
                        nowSb.append(", ");
                    }
                    nowSb.append(pool);
                }
                if (nowSb.length() == 0) {
                    nowSb.append("<empty>");
                }
            } else {
                nowSb.append("<unknown>");
            }
            _log.debug("      now: " + nowSb.toString());
        }
    }

    private void updateTodoBasedOnPoolSpace(Set<String> recalcPoolgroup, Map<String, Set<String>> futurePoolgroupMembership, Map<String, SpaceInfo> currentPoolSpaceInfo, Map<String, SpaceInfo> futurePoolSpaceInfo) {
        HashSet<String> changedPools = new HashSet<String>();
        for (Map.Entry<String, SpaceInfo> preInfoEntry : currentPoolSpaceInfo.entrySet()) {
            String thisPool = preInfoEntry.getKey();
            SpaceInfo thisPoolPreInfo = preInfoEntry.getValue();
            SpaceInfo thisPoolPostInfo = futurePoolSpaceInfo.get(thisPool);
            if (_log.isDebugEnabled()) {
                _log.debug("  examining pool: " + thisPool);
            }
            if (thisPoolPostInfo != null && thisPoolPostInfo.equals(thisPoolPreInfo)) continue;
            changedPools.add(thisPool);
            if (!_log.isDebugEnabled()) continue;
            _log.debug("    pool " + thisPool + " has changed or disappeared");
        }
        for (String thisPool : futurePoolSpaceInfo.keySet()) {
            if (currentPoolSpaceInfo.containsKey(thisPool)) continue;
            changedPools.add(thisPool);
            if (!_log.isDebugEnabled()) continue;
            _log.debug("    pool " + thisPool + " has appeared");
        }
        if (changedPools.size() == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug("  no pools have changed");
            }
            return;
        }
        HashMap<String, HashSet<String>> poolToPoolgroups = new HashMap<String, HashSet<String>>();
        for (Map.Entry<String, Set<String>> pgPoolEntry : futurePoolgroupMembership.entrySet()) {
            String thisPoolgroup = pgPoolEntry.getKey();
            for (String thisPool : pgPoolEntry.getValue()) {
                HashSet<String> thisPoolPg = (HashSet<String>)poolToPoolgroups.get(thisPool);
                if (thisPoolPg == null) {
                    thisPoolPg = new HashSet<String>();
                    poolToPoolgroups.put(thisPool, thisPoolPg);
                }
                thisPoolPg.add(thisPoolgroup);
            }
        }
        for (String pool : changedPools) {
            Set poolgroupSet = (Set)poolToPoolgroups.get(pool);
            if (poolgroupSet == null) continue;
            for (String poolgroup : poolgroupSet) {
                recalcPoolgroup.add(poolgroup);
                if (changedPools.size() != 0) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug("  poolgroup " + poolgroup + " is marked as to be recalculated.");
                }
                return;
            }
        }
    }
}

