/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.secondaryInfoProviders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.secondaryInfoProviders.AbstractStateWatcher;
import org.dcache.services.info.stateInfo.LinkInfo;
import org.dcache.services.info.stateInfo.LinkInfoVisitor;
import org.dcache.services.info.stateInfo.PoolSpaceVisitor;
import org.dcache.services.info.stateInfo.SpaceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalisedAccessSpaceMaintainer
extends AbstractStateWatcher {
    private static Logger _log = LoggerFactory.getLogger(NormalisedAccessSpaceMaintainer.class);
    private static final Map<LinkInfo.UNIT_TYPE, String> UNIT_TYPE_STORAGE_NAME = Collections.unmodifiableMap(new HashMap<LinkInfo.UNIT_TYPE, String>(){
        {
            this.put(LinkInfo.UNIT_TYPE.DCACHE, "dcache");
            this.put(LinkInfo.UNIT_TYPE.STORE, "store");
        }
    });
    private static final Map<LinkInfo.OPERATION, String> OPERATION_STORAGE_NAME = Collections.unmodifiableMap(new HashMap<LinkInfo.OPERATION, String>(){
        {
            this.put(LinkInfo.OPERATION.READ, "read");
            this.put(LinkInfo.OPERATION.WRITE, "write");
            this.put(LinkInfo.OPERATION.CACHE, "stage");
        }
    });
    private static final String[] PREDICATE_PATHS = new String[]{"links.*.pools.*", "links.*.units.store.*", "links.*.units.dcache.*", "pools.*.space.*"};
    private static final StatePath NAS_PATH = new StatePath("nas");

    @Override
    protected String[] getPredicates() {
        return PREDICATE_PATHS;
    }

    @Override
    public void trigger(StateUpdate update, StateExhibitor currentState, StateExhibitor futureState) {
        Map<String, LinkInfo> currentLinks = LinkInfoVisitor.getDetails(currentState);
        Map<String, LinkInfo> futureLinks = LinkInfoVisitor.getDetails(futureState);
        Map<String, SpaceInfo> currentPools = PoolSpaceVisitor.getDetails(currentState);
        Map<String, SpaceInfo> futurePools = PoolSpaceVisitor.getDetails(futureState);
        this.buildUpdate(update, currentPools, futurePools, currentLinks, futureLinks);
    }

    private Map<String, NasInfo> buildNas(Map<String, SpaceInfo> poolSpaceInfo, Map<String, LinkInfo> links) {
        HashMap<String, PaintInfo> paintedPools = new HashMap<String, PaintInfo>();
        for (String poolId : poolSpaceInfo.keySet()) {
            paintedPools.put(poolId, new PaintInfo(poolId));
        }
        for (LinkInfo linkInfo : links.values()) {
            for (String linkPool : linkInfo.getPools()) {
                PaintInfo poolPaintInfo = (PaintInfo)paintedPools.get(linkPool);
                if (poolPaintInfo == null) {
                    _log.debug("Inconsistency in information: pool " + linkPool + " accessible via link " + linkInfo.getId() + " but not present as a pool");
                    poolPaintInfo = new PaintInfo(linkPool);
                    paintedPools.put(linkPool, poolPaintInfo);
                }
                poolPaintInfo.addAccess(linkInfo);
            }
        }
        HashMap<String, NasInfo> nas = new HashMap<String, NasInfo>();
        for (Map.Entry paintEntry : paintedPools.entrySet()) {
            NasInfo _thisNas;
            PaintInfo poolPaintInfo = (PaintInfo)paintEntry.getValue();
            String poolId = (String)paintEntry.getKey();
            String nasName = poolPaintInfo.getNasName();
            if (!nas.containsKey(nasName)) {
                _thisNas = new NasInfo();
                nas.put(nasName, _thisNas);
            } else {
                _thisNas = (NasInfo)nas.get(nasName);
            }
            _thisNas.addPool(poolId, poolSpaceInfo.get(poolId), poolPaintInfo);
        }
        return nas;
    }

    private StateUpdate buildUpdate(StateUpdate update, Map<String, SpaceInfo> currentPools, Map<String, SpaceInfo> futurePools, Map<String, LinkInfo> currentLinks, Map<String, LinkInfo> futureLinks) {
        boolean buildAll = false;
        Set<String> alteredPools = null;
        Map<String, NasInfo> nas = this.buildNas(futurePools, futureLinks);
        if (!currentLinks.equals(futureLinks)) {
            update.purgeUnder(NAS_PATH);
            buildAll = true;
        } else {
            alteredPools = this.identifyPoolsThatHaveChanged(currentPools, futurePools);
        }
        for (Map.Entry<String, NasInfo> e : nas.entrySet()) {
            String nasName = e.getKey();
            NasInfo nasInfo = e.getValue();
            if (!buildAll && !nasInfo.havePoolInSet(alteredPools)) continue;
            nasInfo.addMetrics(update, nasName);
        }
        return update;
    }

    private Set<String> identifyPoolsThatHaveChanged(Map<String, SpaceInfo> currentPools, Map<String, SpaceInfo> futurePools) {
        HashSet<String> alteredPools = new HashSet<String>();
        HashSet<Map.Entry<String, SpaceInfo>> d1 = new HashSet<Map.Entry<String, SpaceInfo>>(currentPools.entrySet());
        HashSet<Map.Entry<String, SpaceInfo>> d2 = new HashSet<Map.Entry<String, SpaceInfo>>(futurePools.entrySet());
        d1.removeAll(futurePools.entrySet());
        d2.removeAll(currentPools.entrySet());
        for (Map.Entry entry : d1) {
            alteredPools.add((String)entry.getKey());
        }
        for (Map.Entry entry : d2) {
            alteredPools.add((String)entry.getKey());
        }
        return alteredPools;
    }

    private static class NasInfo {
        private final SpaceInfo _spaceInfo = new SpaceInfo();
        private final Set<String> _pools = new HashSet<String>();
        private PaintInfo _representativePaintInfo;

        private NasInfo() {
        }

        void addPool(String poolId, SpaceInfo spaceInfo, PaintInfo pInfo) {
            this._pools.add(poolId);
            this._spaceInfo.add(spaceInfo);
            if (this._representativePaintInfo == null) {
                this._representativePaintInfo = pInfo;
            } else if (!this._representativePaintInfo.equals(pInfo)) {
                throw new RuntimeException("Adding pool " + poolId + " with differeing paintInfo from first pool " + this._representativePaintInfo.getPoolId());
            }
        }

        boolean havePoolInSet(Set<String> pools) {
            return !Collections.disjoint(pools, this._pools);
        }

        void addMetrics(StateUpdate update, String nasName) {
            StatePath thisNasPath = NAS_PATH.newChild(nasName);
            StatePath thisNasPoolsPath = thisNasPath.newChild("pools");
            update.appendUpdateCollection(thisNasPoolsPath, this._pools, true);
            this._spaceInfo.addMetrics(update, thisNasPath.newChild("space"), true);
            StatePath thisNasLinksPath = thisNasPath.newChild("links");
            update.appendUpdateCollection(thisNasLinksPath, this._representativePaintInfo.getLinks(), true);
            StatePath thisNasUnitsPath = thisNasPath.newChild("units");
            for (LinkInfo.UNIT_TYPE type : PaintInfo.CONSIDERED_UNIT_TYPES) {
                Map<LinkInfo.OPERATION, Set<String>> unitsMap = this._representativePaintInfo.getUnits(type);
                if (unitsMap == null) {
                    _log.error("A considered unit-type query to getUnits() gave null reply.  This is unexpected.");
                    continue;
                }
                if (!UNIT_TYPE_STORAGE_NAME.containsKey((Object)type)) {
                    _log.error("Unmapped unit type " + (Object)((Object)type));
                    continue;
                }
                StatePath thisNasUnitTypePath = thisNasUnitsPath.newChild((String)UNIT_TYPE_STORAGE_NAME.get((Object)type));
                for (Map.Entry<LinkInfo.OPERATION, Set<String>> entry : unitsMap.entrySet()) {
                    LinkInfo.OPERATION operation = entry.getKey();
                    Set<String> units = entry.getValue();
                    if (!OPERATION_STORAGE_NAME.containsKey((Object)operation)) {
                        _log.error("Unmapped operation " + (Object)((Object)operation));
                        continue;
                    }
                    update.appendUpdateCollection(thisNasUnitTypePath.newChild((String)OPERATION_STORAGE_NAME.get((Object)operation)), units, true);
                }
            }
        }
    }

    protected static class PaintInfo {
        public static final String NAS_NAME_INACCESSIBLE = "inaccessible";
        public static final String NAS_NAME_TOO_LONG_PREFIX = "complex-";
        public static final int NAS_NAME_MAX_LENGTH = 100;
        private static final Set<LinkInfo.OPERATION> CONSIDERED_OPERATIONS = EnumSet.of(LinkInfo.OPERATION.READ, LinkInfo.OPERATION.WRITE, LinkInfo.OPERATION.CACHE);
        private static final Set<LinkInfo.UNIT_TYPE> CONSIDERED_UNIT_TYPES = EnumSet.of(LinkInfo.UNIT_TYPE.DCACHE, LinkInfo.UNIT_TYPE.STORE);
        private final String _poolId;
        private final Set<String> _links = new HashSet<String>();
        private String _nasName;
        private final Map<LinkInfo.UNIT_TYPE, Map<LinkInfo.OPERATION, Set<String>>> _storedUnits;

        public PaintInfo(String poolId) {
            this._poolId = poolId;
            HashMap storedUnits = new HashMap();
            this._storedUnits = Collections.unmodifiableMap(storedUnits);
            for (LinkInfo.UNIT_TYPE unitType : CONSIDERED_UNIT_TYPES) {
                HashMap storedUnitsForType = new HashMap();
                storedUnits.put(unitType, Collections.unmodifiableMap(storedUnitsForType));
                for (LinkInfo.OPERATION operation : CONSIDERED_OPERATIONS) {
                    storedUnitsForType.put(operation, new HashSet());
                }
            }
        }

        synchronized void addAccess(LinkInfo link) {
            this.invalidateNasNameCache();
            for (LinkInfo.OPERATION operation : CONSIDERED_OPERATIONS) {
                if (!link.isAccessableFor(operation)) continue;
                for (LinkInfo.UNIT_TYPE unitType : CONSIDERED_UNIT_TYPES) {
                    for (String unit : link.getUnits(unitType)) {
                        this.addAccessForUnit(link.getId(), operation, unitType, unit);
                    }
                }
            }
        }

        private void addAccessForUnit(String linkName, LinkInfo.OPERATION operation, LinkInfo.UNIT_TYPE unitType, String unitName) {
            this._storedUnits.get((Object)unitType).get((Object)operation).add(unitName);
            this._links.add(linkName);
        }

        private void invalidateNasNameCache() {
            this._nasName = null;
        }

        private boolean isNasNameCacheValid() {
            return this._nasName != null;
        }

        private void buildNasNameCache() {
            StringBuilder sb = new StringBuilder();
            for (LinkInfo.UNIT_TYPE unitType : CONSIDERED_UNIT_TYPES) {
                StringBuilder unitTypePart = this.getUnitTypeName(unitType);
                if (unitTypePart == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(unitType.getNasNamePrefix());
                sb.append("{");
                sb.append((CharSequence)unitTypePart);
                sb.append("}");
            }
            this._nasName = sb.length() > 100 ? NAS_NAME_TOO_LONG_PREFIX + Integer.toHexString(sb.toString().hashCode()) : (sb.length() > 0 ? sb.toString() : NAS_NAME_INACCESSIBLE);
        }

        synchronized String getNasName() {
            if (!this.isNasNameCacheValid()) {
                this.buildNasNameCache();
            }
            return this._nasName;
        }

        private StringBuilder getUnitTypeName(LinkInfo.UNIT_TYPE unitType) {
            HashMap<LinkInfo.OPERATION, String> operationsUnitsDescription = new HashMap<LinkInfo.OPERATION, String>();
            for (LinkInfo.OPERATION operation : CONSIDERED_OPERATIONS) {
                String description = this.getUnitOperationTypeString(unitType, operation);
                operationsUnitsDescription.put(operation, description);
            }
            EnumSet<LinkInfo.OPERATION> processedOperations = EnumSet.noneOf(LinkInfo.OPERATION.class);
            StringBuilder sb = new StringBuilder();
            for (LinkInfo.OPERATION operation : CONSIDERED_OPERATIONS) {
                String unitsDescription = (String)operationsUnitsDescription.get((Object)operation);
                if (processedOperations.contains((Object)operation)) continue;
                processedOperations.add(operation);
                if (unitsDescription == null) continue;
                if (sb.length() != 0) {
                    sb.append(";");
                }
                sb.append(operation.getNasNamePrefix());
                for (LinkInfo.OPERATION otherOperation : EnumSet.complementOf(processedOperations)) {
                    String otherUnitsDescription = (String)operationsUnitsDescription.get((Object)otherOperation);
                    if (!unitsDescription.equals(otherUnitsDescription)) continue;
                    processedOperations.add(otherOperation);
                    sb.append(otherOperation.getNasNamePrefix());
                }
                sb.append(":");
                sb.append(unitsDescription);
            }
            return sb.length() != 0 ? sb : null;
        }

        private String getUnitOperationTypeString(LinkInfo.UNIT_TYPE unitType, LinkInfo.OPERATION operation) {
            Set<String> units = this._storedUnits.get((Object)unitType).get((Object)operation);
            if (units.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<String> sortedUnits = new ArrayList<String>(units);
            Collections.sort(sortedUnits);
            boolean isFirstUnit = true;
            for (String unit : sortedUnits) {
                if (isFirstUnit) {
                    isFirstUnit = false;
                } else {
                    sb.append(",");
                }
                sb.append(unit);
            }
            return sb.toString();
        }

        protected Set<String> getLinks() {
            return this._links;
        }

        String getPoolId() {
            return this._poolId;
        }

        public Set<String> getUnits(LinkInfo.UNIT_TYPE unitType, LinkInfo.OPERATION operation) {
            Map<LinkInfo.OPERATION, Set<String>> storedUnitsForType = this.getUnits(unitType);
            if (storedUnitsForType == null || !storedUnitsForType.containsKey((Object)operation)) {
                return null;
            }
            return Collections.unmodifiableSet(storedUnitsForType.get((Object)operation));
        }

        public Map<LinkInfo.OPERATION, Set<String>> getUnits(LinkInfo.UNIT_TYPE unitType) {
            if (!this._storedUnits.containsKey((Object)unitType)) {
                return null;
            }
            return Collections.unmodifiableMap(this._storedUnits.get((Object)unitType));
        }

        public int hashCode() {
            return this._storedUnits.hashCode();
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (!(otherObject instanceof PaintInfo)) {
                return false;
            }
            PaintInfo otherPI = (PaintInfo)otherObject;
            return this._storedUnits.equals(otherPI._storedUnits);
        }
    }
}

