/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.secondaryInfoProviders;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.secondaryInfoProviders.AbstractStateWatcher;
import org.dcache.services.info.stateInfo.SimpleIntegerMapVisitor;
import org.dcache.services.info.stateInfo.SimpleStringMapVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkgroupTotalSpaceMaintainer
extends AbstractStateWatcher {
    private static Logger _log = LoggerFactory.getLogger(LinkgroupTotalSpaceMaintainer.class);
    private static final StatePath RESERVATIONS = new StatePath("reservations");
    private static final StatePath LINKGROUPS = new StatePath("linkgroups");
    private static final StatePath LINKGROUPREF = new StatePath("linkgroupref");
    private static final StatePath SPACE_USED = StatePath.parsePath("space.used");
    private static final StatePath SPACE_FREE = StatePath.parsePath("space.free");
    private static final String[] PREDICATE_PATHS = new String[]{"reservations.*.space.used", "linkgroups.*.space.free", "linkgroups.*.reservations.*"};

    @Override
    protected String[] getPredicates() {
        return PREDICATE_PATHS;
    }

    @Override
    public void trigger(StateUpdate update, StateExhibitor currentState, StateExhibitor futureState) {
        super.trigger(update, currentState, futureState);
        if (_log.isInfoEnabled()) {
            _log.info("Watcher " + this.getClass().getSimpleName() + " triggered");
        }
        Map<String, Long> freeSpaceAfter = SimpleIntegerMapVisitor.buildMap(futureState, LINKGROUPS, SPACE_FREE);
        Map<String, Long> usedSpaceAfter = SimpleIntegerMapVisitor.buildMap(futureState, RESERVATIONS, SPACE_USED);
        Map<String, String> reservationToLinkgroup = SimpleStringMapVisitor.buildMap(futureState, RESERVATIONS, LINKGROUPREF);
        HashSet<String> linkgroupsToUpdate = new HashSet<String>();
        this.addLinkgroupsWhereUsedSpaceChanged(currentState, linkgroupsToUpdate, usedSpaceAfter, reservationToLinkgroup);
        this.addLinkgroupsWhereFreeChanged(currentState, linkgroupsToUpdate, freeSpaceAfter);
        if (linkgroupsToUpdate.isEmpty()) {
            _log.warn(this.getClass().getSimpleName() + " triggered, but apparently nothing needs doing.");
            return;
        }
        this.addLinkgroupChanges(update, linkgroupsToUpdate, freeSpaceAfter, usedSpaceAfter, reservationToLinkgroup);
    }

    private void addLinkgroupsWhereUsedSpaceChanged(StateExhibitor currentState, Set<String> linkgroupsToUpdate, Map<String, Long> usedSpaceAfter, Map<String, String> reservationToLinkgroup) {
        Map<String, Long> usedSpaceNow = SimpleIntegerMapVisitor.buildMap(currentState, RESERVATIONS, SPACE_USED);
        if (usedSpaceNow.equals(usedSpaceAfter)) {
            if (_log.isDebugEnabled()) {
                _log.debug("No update needed for reservation used space changing.");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Updates due to reservation used space changing:");
        }
        for (String reservationId : usedSpaceAfter.keySet()) {
            if (usedSpaceAfter.get(reservationId).equals(usedSpaceNow.get(reservationId))) continue;
            String linkgroupId = reservationToLinkgroup.get(reservationId);
            if (_log.isDebugEnabled()) {
                _log.debug("    linkgroup: " + linkgroupId);
            }
            linkgroupsToUpdate.add(linkgroupId);
        }
    }

    private void addLinkgroupsWhereFreeChanged(StateExhibitor currentState, Set<String> linkgroupsToUpdate, Map<String, Long> freeSpaceAfter) {
        Map<String, Long> freeSpaceNow = SimpleIntegerMapVisitor.buildMap(currentState, LINKGROUPS, SPACE_USED);
        if (freeSpaceNow.equals(freeSpaceAfter)) {
            if (_log.isDebugEnabled()) {
                _log.debug("No update needed for linkgroup free space changing.");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Updates due to linkgroup free space changing:");
        }
        for (String linkgroupId : freeSpaceAfter.keySet()) {
            if (freeSpaceAfter.get(linkgroupId).equals(freeSpaceNow.get(linkgroupId))) continue;
            if (_log.isDebugEnabled()) {
                _log.debug("    linkgroup: " + linkgroupId);
            }
            linkgroupsToUpdate.add(linkgroupId);
        }
    }

    private void addLinkgroupChanges(StateUpdate update, Set<String> linkgroupsToUpdate, Map<String, Long> freeStateAfter, Map<String, Long> usedSpaceAfter, Map<String, String> reservationToLinkgroup) {
        for (String linkgroupId : linkgroupsToUpdate) {
            if (_log.isDebugEnabled()) {
                _log.debug("Building update for linkgroup " + linkgroupId);
            }
            StatePath thisLinkgroupSpace = LINKGROUPS.newChild(linkgroupId).newChild("space");
            long used = 0L;
            for (Map.Entry<String, Long> entry : usedSpaceAfter.entrySet()) {
                if (!linkgroupId.equals(reservationToLinkgroup.get(entry.getKey()))) continue;
                used += entry.getValue().longValue();
            }
            update.appendUpdate(thisLinkgroupSpace.newChild("used"), new IntegerStateValue(used));
            Long freeLong = freeStateAfter.get(linkgroupId);
            if (freeLong != null) {
                update.appendUpdate(thisLinkgroupSpace.newChild("total"), new IntegerStateValue(used + freeLong));
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug("failed to find linkgroup " + linkgroupId + " in freeStateAfter");
        }
    }
}

