/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.routingmanager;

import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.SkelListBasedActivity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMgrDga
extends SkelListBasedActivity {
    private static final Logger _log = LoggerFactory.getLogger(RoutingMgrDga.class);
    private final MessageSender _sender;
    private static int MIN_LIST_REFRESH_PERIOD = 300000;
    private static int SUCC_MSG_DELAY = 5000;
    private final CellMessageAnswerable _handler;

    public RoutingMgrDga(StateExhibitor exhibitor, MessageSender sender, CellMessageAnswerable handler) {
        super(exhibitor, new StatePath("domains"), MIN_LIST_REFRESH_PERIOD, SUCC_MSG_DELAY);
        this._sender = sender;
        this._handler = handler;
    }

    @Override
    public void trigger() {
        super.trigger();
        String domainName = this.getNextItem();
        if (domainName == null) {
            return;
        }
        CellPath routingMgrCellPath = new CellPath("RoutingMgr", domainName);
        if (_log.isInfoEnabled()) {
            _log.info("sending message \"ls -x\" to RoutingMgr cell on domain " + domainName);
        }
        this._sender.sendMessage(this.getMetricLifetime(), this._handler, routingMgrCellPath, "ls -x");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

