/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.poolmanager;

import dmg.cells.nucleus.UOID;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitInfoMsgHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(UnitInfoMsgHandler.class);
    private static final StatePath UNITS_PATH = new StatePath("units");

    public UnitInfoMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        if (!msgPayload.getClass().isArray()) {
            _log.error("unexpected received non-array payload");
            return;
        }
        Object[] array = (Object[])msgPayload;
        if (array.length != 3) {
            _log.error("Unexpected array size: " + array.length);
            return;
        }
        String unitName = array[0].toString();
        String unitType = array[1].toString();
        StatePath thisUnitPath = UNITS_PATH.newChild(unitName);
        StateUpdate update = new StateUpdate();
        update.appendUpdate(thisUnitPath.newChild("type"), new StringStateValue(unitType, metricLifetime));
        this.addItems(update, thisUnitPath.newChild("unitgroups"), (Object[])array[2], metricLifetime);
        this.applyUpdates(update);
    }
}

