/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.poolmanager;

import dmg.cells.nucleus.UOID;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGroupInfoMsgHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(UGroupInfoMsgHandler.class);
    private static final StatePath UNITGROUP_PATH = new StatePath("unitgroups");

    public UGroupInfoMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        if (!msgPayload.getClass().isArray()) {
            _log.error("unexpected received non-array payload");
            return;
        }
        Object[] array = (Object[])msgPayload;
        if (array.length != 3) {
            _log.error("unexpected array size: " + array.length);
            return;
        }
        String unitGroupName = (String)array[0];
        StatePath thisUGroupPath = UNITGROUP_PATH.newChild(unitGroupName);
        StateUpdate update = new StateUpdate();
        this.addItems(update, thisUGroupPath.newChild("units"), (Object[])array[1], metricLifetime);
        this.addItems(update, thisUGroupPath.newChild("links"), (Object[])array[2], metricLifetime);
        this.applyUpdates(update);
    }
}

