/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.poolmanager;

import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.UOID;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.DgaFactoryService;
import org.dcache.services.info.gathers.ListBasedMessageDga;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.Schedulable;
import org.dcache.services.info.gathers.SingleMessageDga;
import org.dcache.services.info.gathers.StringListMsgHandler;
import org.dcache.services.info.gathers.poolmanager.LinkInfoMsgHandler;
import org.dcache.services.info.gathers.poolmanager.PoolCostMsgHandler;
import org.dcache.services.info.gathers.poolmanager.PoolGroupInfoMsgHandler;
import org.dcache.services.info.gathers.poolmanager.PoolInfoMsgHandler;
import org.dcache.services.info.gathers.poolmanager.UGroupInfoMsgHandler;
import org.dcache.services.info.gathers.poolmanager.UnitInfoMsgHandler;

public class PoolManagerDgaFactoryService
implements DgaFactoryService {
    @Override
    public Set<Schedulable> createDgas(StateExhibitor exhibitor, MessageSender sender, StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        return new DgaFactory(exhibitor, sender, sum, msgMetaRepo).get();
    }

    private static class DgaFactory {
        private final StateExhibitor _exhibitor;
        private final MessageSender _sender;
        private final StateUpdateManager _sum;
        private final MessageMetadataRepository<UOID> _msgMetaRepo;
        private final Set<Schedulable> _activity = new HashSet<Schedulable>();

        DgaFactory(StateExhibitor exhibitor, MessageSender sender, StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
            this._exhibitor = exhibitor;
            this._sender = sender;
            this._sum = sum;
            this._msgMetaRepo = msgMetaRepo;
            this.addListCommandAsDga("pools", "psux ls pool");
            this.addListCommandAsDga("poolgroups", "psux ls pgroup");
            this.addListCommandAsDga("units", "psux ls unit");
            this.addListCommandAsDga("unitgroups", "psux ls ugroup");
            this.addSingleMessageDga("xcm ls", new PoolCostMsgHandler(this._sum, this._msgMetaRepo));
            this.addSingleMessageDga("psux ls link -x -resolve", new LinkInfoMsgHandler(this._sum, this._msgMetaRepo));
            this.addListBasedDgaForChildrenOf("pools", "psux ls pool", new PoolInfoMsgHandler(this._sum, this._msgMetaRepo));
            this.addListBasedDgaForChildrenOf("poolgroups", "psux ls pgroup", new PoolGroupInfoMsgHandler(this._sum, this._msgMetaRepo));
            this.addListBasedDgaForChildrenOf("units", "psux ls unit", new UnitInfoMsgHandler(this._sum, this._msgMetaRepo));
            this.addListBasedDgaForChildrenOf("unitgroups", "psux ls ugroup", new UGroupInfoMsgHandler(this._sum, this._msgMetaRepo));
        }

        public Set<Schedulable> get() {
            return this._activity;
        }

        private void addListBasedDgaForChildrenOf(String path, String prefix, CellMessageAnswerable response) {
            this._activity.add(new ListBasedMessageDga(this._exhibitor, this._sender, new StatePath(path), "PoolManager", prefix, response));
        }

        private void addListCommandAsDga(String path, String command) {
            this.addSingleMessageDga(command, new StringListMsgHandler(this._sum, this._msgMetaRepo, path));
        }

        private void addSingleMessageDga(String command, CellMessageAnswerable response) {
            this._activity.add(new SingleMessageDga(this._sender, "PoolManager", command, response, TimeUnit.MINUTES.toSeconds(5L)));
        }
    }
}

