/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.poolmanager;

import dmg.cells.nucleus.UOID;
import java.util.ArrayList;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkInfoMsgHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(LinkInfoMsgHandler.class);
    private static final int EXPECTED_ARRAY_SIZE = 13;

    public LinkInfoMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        StateUpdate update = null;
        ArrayList linkInfoArray = (ArrayList)msgPayload;
        StatePath linksPath = new StatePath("links");
        for (Object o : linkInfoArray) {
            if (!o.getClass().isArray()) {
                _log.error("Link information not an array.");
                continue;
            }
            Object[] array = (Object[])o;
            if (array.length != 13) {
                _log.error("Unexpected array size: " + array.length);
                continue;
            }
            if (update == null) {
                update = new StateUpdate();
            }
            this.processInfo(update, linksPath, (Object[])o, metricLifetime);
        }
        if (update != null) {
            this.applyUpdates(update);
        }
    }

    private void processInfo(StateUpdate update, StatePath linksPath, Object[] o, long lifetime) {
        String name = (String)o[0];
        int readPref = (Integer)o[1];
        int cachePref = (Integer)o[2];
        int writePref = (Integer)o[3];
        Object[] uGroups = (Object[])o[4];
        Object[] pools = (Object[])o[5];
        Object[] groups = (Object[])o[6];
        int p2pPref = (Integer)o[7];
        String tag = (String)o[8];
        Object[] store = (Object[])o[9];
        Object[] net = (Object[])o[10];
        Object[] dcache = (Object[])o[11];
        Object[] protocol = (Object[])o[12];
        StatePath thisLinkPath = linksPath.newChild(name);
        StatePath prefPath = thisLinkPath.newChild("prefs");
        update.appendUpdate(prefPath.newChild("read"), new IntegerStateValue((long)readPref, lifetime));
        update.appendUpdate(prefPath.newChild("cache"), new IntegerStateValue((long)cachePref, lifetime));
        update.appendUpdate(prefPath.newChild("write"), new IntegerStateValue((long)writePref, lifetime));
        update.appendUpdate(prefPath.newChild("p2p"), new IntegerStateValue((long)p2pPref, lifetime));
        if (uGroups != null) {
            this.addItems(update, thisLinkPath.newChild("unitgroups"), uGroups, lifetime);
        }
        this.addItems(update, thisLinkPath.newChild("pools"), pools, lifetime);
        this.addItems(update, thisLinkPath.newChild("poolgroups"), groups, lifetime);
        update.appendUpdate(thisLinkPath.newChild("selection"), new StringStateValue(tag != null ? tag : "None", lifetime));
        StatePath unitPath = thisLinkPath.newChild("units");
        this.addItems(update, unitPath.newChild("store"), store, lifetime);
        this.addItems(update, unitPath.newChild("net"), net, lifetime);
        this.addItems(update, unitPath.newChild("dcache"), dcache, lifetime);
        this.addItems(update, unitPath.newChild("protocol"), protocol, lifetime);
        update.appendUpdate(thisLinkPath.newChild("space"), new StateComposite(lifetime));
    }
}

