/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.loginbroker;

import dmg.cells.nucleus.UOID;
import dmg.cells.services.login.LoginBrokerInfo;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginBrokerLsMsgHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(LoginBrokerLsMsgHandler.class);
    private static final StatePath PATH_TO_DOORS = new StatePath("doors");

    public LoginBrokerLsMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        if (!msgPayload.getClass().isArray()) {
            _log.error("unexpected received non-array payload");
            return;
        }
        Object[] array = (Object[])msgPayload;
        if (array.length == 0) {
            return;
        }
        StateUpdate update = new StateUpdate();
        for (Object element : array) {
            if (!(element instanceof LoginBrokerInfo)) {
                _log.warn("Skipping array element that is not LoginBrokerInfo");
                continue;
            }
            LoginBrokerInfo info = (LoginBrokerInfo)element;
            this.addDoorInfo(update, PATH_TO_DOORS.newChild(info.getIdentifier()), info, metricLifetime);
        }
        this.applyUpdates(update);
    }

    private void addDoorInfo(StateUpdate update, StatePath pathToDoor, LoginBrokerInfo info, long lifetime) {
        StatePath pathToProtocol = pathToDoor.newChild("protocol");
        this.conditionalAddString(update, pathToProtocol, "engine", info.getProtocolEngine(), lifetime);
        this.conditionalAddString(update, pathToProtocol, "family", info.getProtocolFamily(), lifetime);
        this.conditionalAddString(update, pathToProtocol, "version", info.getProtocolVersion(), lifetime);
        update.appendUpdate(pathToDoor.newChild("load"), new FloatingPointStateValue(info.getLoad(), lifetime));
        update.appendUpdate(pathToDoor.newChild("port"), new IntegerStateValue((long)info.getPort(), lifetime));
        update.appendUpdate(pathToDoor.newChild("cell"), new StringStateValue(info.getCellName(), lifetime));
        update.appendUpdate(pathToDoor.newChild("domain"), new StringStateValue(info.getDomainName(), lifetime));
        update.appendUpdate(pathToDoor.newChild("update-time"), new IntegerStateValue(info.getUpdateTime(), lifetime));
        StatePath pathToInterfaces = pathToDoor.newChild("interfaces");
        String[] interfaceNames = info.getHosts();
        if (interfaceNames != null) {
            for (int i = 0; i < interfaceNames.length; ++i) {
                if (interfaceNames[i] == null) continue;
                this.addInterfaceInfo(update, pathToInterfaces, interfaceNames[i], i + 1, lifetime);
            }
        }
    }

    private void conditionalAddString(StateUpdate update, StatePath parentPath, String name, String value, long storeTime) {
        if (value != null) {
            update.appendUpdate(parentPath.newChild(name), new StringStateValue(value, storeTime));
        }
    }

    private void addInterfaceInfo(StateUpdate update, StatePath parentPath, String name, int order, long lifetime) {
        String id = name + "-" + order;
        StatePath pathToInterfaceBranch = parentPath.newChild(id);
        update.appendUpdate(pathToInterfaceBranch.newChild("name"), new StringStateValue(name, lifetime));
        try {
            InetAddress address = InetAddress.getByName(name);
            update.appendUpdate(pathToInterfaceBranch.newChild("FQDN"), new StringStateValue(address.getCanonicalHostName(), lifetime));
            update.appendUpdate(pathToInterfaceBranch.newChild("address"), new StringStateValue(address.getHostAddress(), lifetime));
            update.appendUpdate(pathToInterfaceBranch.newChild("address-type"), new StringStateValue(address instanceof Inet4Address ? "IPv4" : (address instanceof Inet6Address ? "IPv6" : "unknown"), lifetime));
            update.appendUpdate(pathToInterfaceBranch.newChild("order"), new IntegerStateValue((long)order, lifetime));
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
    }
}

