/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.domain;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.UOID;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StateValue;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDomainMsgHandler
extends CellMessageHandlerSkel {
    private static final Logger _log = LoggerFactory.getLogger(StaticDomainMsgHandler.class);
    private static final StatePath DOMAINS = StatePath.parsePath("domains");

    public StaticDomainMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object payload, long lifetime) {
        if (payload == null) {
            _log.error("received null payload");
            return;
        }
        if (!(payload instanceof String)) {
            _log.error("received message of type {}", (Object)payload.getClass().getCanonicalName());
            return;
        }
        String declaration = (String)payload;
        StatePath parent = this.metricsParent();
        StateUpdate update = this.processDeclaration(parent, lifetime, declaration);
        this.applyUpdates(update);
    }

    private StatePath metricsParent() {
        return DOMAINS.newChild(this.getDomain()).newChild("static");
    }

    private StateUpdate processDeclaration(StatePath parent, long lifetime, String declaration) {
        StateUpdate update = new StateUpdate();
        update.purgeUnder(parent);
        for (String rawLine : declaration.split("\n")) {
            String line = rawLine.trim();
            if (line.isEmpty()) continue;
            try {
                this.processLine(update, lifetime, parent, line);
            }
            catch (IllegalArgumentException e) {
                _log.error(e.getMessage());
            }
        }
        return update;
    }

    private void processLine(StateUpdate update, long lifetime, StatePath parent, String line) {
        Preconditions.checkArgument((line.length() >= 5 ? 1 : 0) != 0, (Object)("Line too short: " + line));
        char type = line.charAt(0);
        char seperator = line.charAt(1);
        int idx = line.indexOf(seperator, 3);
        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (Object)("Seperator character '" + seperator + "' missing"));
        Preconditions.checkArgument((idx != line.length() - 1 ? 1 : 0) != 0, (Object)"Metric has no data");
        String value = line.substring(idx + 1);
        StateValue metric = StaticDomainMsgHandler.metricFor(type, value, lifetime);
        String name = line.substring(2, idx);
        StatePath relativePath = StatePath.parsePath(name);
        StatePath path = parent.newChild(relativePath);
        update.appendUpdate(path, metric);
    }

    private static StateValue metricFor(char type, String value, long lifetime) {
        switch (type) {
            case 'S': {
                return new StringStateValue(value, lifetime);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

