/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.domain;

import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.SkelListBasedActivity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDomainDga
extends SkelListBasedActivity {
    private static final Logger _log = LoggerFactory.getLogger(StaticDomainDga.class);
    private static final StatePath DOMAINS_PATH = StatePath.parsePath("domains");
    private static final String COMMAND = "show context info.static";
    private final MessageSender _sender;
    private final CellMessageAnswerable _handler;
    private static final int MIN_LIST_REFRESH_PERIOD = 120000;
    private static final int SUCC_MSG_DELAY = 2000;

    public StaticDomainDga(StateExhibitor exhibitor, MessageSender sender, CellMessageAnswerable handler) {
        super(exhibitor, DOMAINS_PATH, 120000, 2000);
        this._sender = sender;
        this._handler = handler;
    }

    @Override
    public void trigger() {
        super.trigger();
        String domain = this.getNextItem();
        if (domain != null) {
            CellPath path = new CellPath("System", domain);
            _log.debug("sending message \"{}\" to System cell on domain {}", (Object)COMMAND, (Object)domain);
            this._sender.sendMessage(this.getMetricLifetime(), this._handler, path, COMMAND);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

