/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.cells;

import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.UOID;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellInfoMsgHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(CellInfoMsgHandler.class);
    private static final StatePath DOMAINS_PATH = new StatePath("domains");

    public CellInfoMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        CellInfo[] cells;
        if (msgPayload == null) {
            _log.error("received null payload from getcellinfos");
            return;
        }
        if (!msgPayload.getClass().isArray()) {
            _log.error("received a message that isn't an array");
            return;
        }
        Class<?> arrayClass = msgPayload.getClass().getComponentType();
        if (arrayClass == null) {
            _log.error("unable to figure out what array type is.");
            return;
        }
        if (!arrayClass.equals(CellInfo.class)) {
            _log.error("received array is not an array of CellInfo");
            return;
        }
        StateUpdate update = new StateUpdate();
        for (CellInfo thisCellInfo : cells = (CellInfo[])msgPayload) {
            String domain = thisCellInfo.getDomainName();
            String cellName = thisCellInfo.getCellName();
            StatePath thisCellPath = DOMAINS_PATH.newChild(domain).newChild("cells").newChild(cellName);
            this.addCellInfo(update, thisCellPath, thisCellInfo, metricLifetime);
        }
        this.applyUpdates(update);
    }

    private void addCellInfo(StateUpdate update, StatePath thisCellPath, CellInfo thisCell, long lifetime) {
        update.appendUpdate(thisCellPath.newChild("class"), new StringStateValue(thisCell.getCellClass(), lifetime));
        update.appendUpdate(thisCellPath.newChild("type"), new StringStateValue(thisCell.getCellType(), lifetime));
        this.addVersionInfo(update, thisCellPath, thisCell.getCellVersion(), lifetime);
        CellMessageHandlerSkel.addTimeMetrics(update, thisCellPath.newChild("created"), thisCell.getCreationTime(), lifetime);
        update.appendUpdate(thisCellPath.newChild("event-queue-size"), new IntegerStateValue((long)thisCell.getEventQueueSize(), lifetime));
        update.appendUpdate(thisCellPath.newChild("thread-count"), new IntegerStateValue((long)thisCell.getThreadCount(), lifetime));
    }

    private void addVersionInfo(StateUpdate update, StatePath parentPath, CellVersion version, long lifetime) {
        StatePath versionPath = parentPath.newChild("version");
        update.appendUpdate(versionPath.newChild("revision"), new StringStateValue(version.getRevision(), lifetime));
        update.appendUpdate(versionPath.newChild("release"), new StringStateValue(version.getRelease(), lifetime));
    }
}

