/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.cells;

import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.SkelListBasedActivity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellInfoDga
extends SkelListBasedActivity {
    private static final Logger _log = LoggerFactory.getLogger(CellInfoDga.class);
    private final MessageSender _sender;
    private static int MIN_LIST_REFRESH_PERIOD = 120000;
    private static int SUCC_MSG_DELAY = 2000;
    private final CellMessageAnswerable _handler;

    public CellInfoDga(StateExhibitor exhibitor, MessageSender sender, CellMessageAnswerable handler) {
        super(exhibitor, new StatePath("domains"), MIN_LIST_REFRESH_PERIOD, SUCC_MSG_DELAY);
        this._handler = handler;
        this._sender = sender;
    }

    @Override
    public void trigger() {
        super.trigger();
        String domainName = this.getNextItem();
        if (domainName == null) {
            return;
        }
        CellPath systemCellPath = new CellPath("System", domainName);
        if (_log.isInfoEnabled()) {
            _log.info("sending message getcellinfos to System cell on domain " + domainName);
        }
        this._sender.sendMessage(this.getMetricLifetime(), this._handler, systemCellPath, "getcellinfos");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

