/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import dmg.cells.nucleus.UOID;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;

public class StringListMsgHandler
extends CellMessageHandlerSkel {
    private final StatePath _path;

    public StringListMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo, String path) {
        super(sum, msgMetaRepo);
        this._path = new StatePath(path);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        Object[] array = (Object[])msgPayload;
        if (array.length == 0) {
            return;
        }
        StateUpdate update = new StateUpdate();
        for (Object element : array) {
            String listItem = (String)element;
            update.appendUpdate(this._path.newChild(listItem), new StateComposite(metricLifetime));
        }
        this.applyUpdates(update);
    }
}

