/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import java.util.Date;
import java.util.Set;
import java.util.Stack;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.gathers.Schedulable;
import org.dcache.services.info.stateInfo.ListVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SkelListBasedActivity
implements Schedulable {
    private static final Logger _log = LoggerFactory.getLogger(SkelListBasedActivity.class);
    private static final int MINIMUM_LIST_REFRESH_PERIOD = 60000;
    private static final int SUCCESSIVE_MSG_DELAY = 10000;
    private long _metricLifetime;
    private Date _whenListRefresh;
    private Date _nextSendMsg = new Date();
    private final Stack<String> _outstandingWork = new Stack();
    private final StatePath _parentPath;
    private final int _minimumListRefreshPeriod;
    private final int _successiveMsgDelay;
    private final StateExhibitor _exhibitor;

    protected SkelListBasedActivity(StateExhibitor exhibitor, StatePath parentPath) {
        this._parentPath = parentPath;
        this._exhibitor = exhibitor;
        this.updateStack();
        this._minimumListRefreshPeriod = 60000;
        this._successiveMsgDelay = 10000;
        this.randomiseDelay();
    }

    protected SkelListBasedActivity(StateExhibitor exhibitor, StatePath parentPath, int minimumListRefreshPeriod, int successiveMsgDelay) {
        this._parentPath = parentPath;
        this._exhibitor = exhibitor;
        this.updateStack();
        this._minimumListRefreshPeriod = minimumListRefreshPeriod;
        this._successiveMsgDelay = successiveMsgDelay;
        this.randomiseDelay();
    }

    private void randomiseDelay() {
        this._whenListRefresh = new Date(System.currentTimeMillis() + (long)(Math.random() * (double)this._minimumListRefreshPeriod));
    }

    @Override
    public Date shouldNextBeTriggered() {
        return this._outstandingWork.empty() ? this._whenListRefresh : this._nextSendMsg;
    }

    @Override
    public void trigger() {
        Date now = new Date();
        this._nextSendMsg = new Date(System.currentTimeMillis() + (long)this._successiveMsgDelay);
        if (!this._outstandingWork.empty() || now.before(this._whenListRefresh)) {
            return;
        }
        this.updateStack();
        long timeToSendAllMsgs = this._outstandingWork.size() * this._successiveMsgDelay;
        long listRefreshPeriod = timeToSendAllMsgs < (long)this._minimumListRefreshPeriod ? (long)this._minimumListRefreshPeriod : timeToSendAllMsgs;
        this._whenListRefresh = new Date(System.currentTimeMillis() + listRefreshPeriod);
        this._metricLifetime = (long)(2.5 * (double)listRefreshPeriod / 1000.0);
    }

    private void updateStack() {
        Set<String> items = ListVisitor.getDetails(this._exhibitor, this._parentPath);
        for (String item : items) {
            this._outstandingWork.add(item);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("fresh to-do list obtained for " + this.getClass().getSimpleName());
            _log.debug("list now contains " + this._outstandingWork.size() + " items");
        }
    }

    public String getNextItem() {
        if (this._outstandingWork.empty()) {
            return null;
        }
        return this._outstandingWork.pop();
    }

    public long getMetricLifetime() {
        return this._metricLifetime;
    }
}

