/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import diskCacheV111.vehicles.Message;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import java.io.Serializable;
import org.dcache.services.info.gathers.MessageHandlerChain;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.SkelPeriodicActivity;

public class SingleMessageDga
extends SkelPeriodicActivity {
    private CellPath _cp;
    private String _requestString;
    private Message _requestMessage;
    private CellMessageAnswerable _handler;
    private final MessageSender _sender;

    public SingleMessageDga(MessageSender sender, String cellName, String request, CellMessageAnswerable handler, long interval) {
        super(interval);
        this._cp = new CellPath(cellName);
        this._requestMessage = null;
        this._requestString = request;
        this._handler = handler;
        this._sender = sender;
    }

    public SingleMessageDga(MessageHandlerChain mhc, String cellName, Message request, long interval) {
        super(interval);
        this._cp = new CellPath(cellName);
        this._requestMessage = request;
        this._requestString = null;
        this._sender = mhc;
    }

    @Override
    public void trigger() {
        super.trigger();
        if (this._requestMessage != null) {
            CellMessage msg = new CellMessage(this._cp, (Serializable)this._requestMessage);
            this._sender.sendMessage(0L, null, msg);
        } else {
            this._sender.sendMessage(super.metricLifetime(), this._handler, this._cp, this._requestString);
        }
    }

    public String toString() {
        String msgName = this._requestMessage != null ? this._requestMessage.getClass().getName() : "'" + this._requestString + "'";
        return this.getClass().getSimpleName() + "[" + this._cp.getCellName() + ", " + msgName + "]";
    }
}

