/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.SkelListBasedActivity;

public class ListBasedMessageDga
extends SkelListBasedActivity {
    private final CellPath _cellPath;
    private final String _messagePrefix;
    private final CellMessageAnswerable _handler;
    private final MessageSender _sender;
    private final String _cellName;
    private final String _parentPath;

    public ListBasedMessageDga(StateExhibitor exhibitor, MessageSender sender, StatePath parent, String cellName, String message, CellMessageAnswerable handler) {
        super(exhibitor, parent);
        this._cellName = cellName;
        this._parentPath = parent.toString();
        this._messagePrefix = message;
        this._handler = handler;
        this._cellPath = new CellPath(cellName);
        this._sender = sender;
    }

    @Override
    public void trigger() {
        super.trigger();
        String item = this.getNextItem();
        if (item == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._messagePrefix);
        sb.append(" ");
        sb.append(item);
        this._sender.sendMessage(this.getMetricLifetime(), this._handler, this._cellPath, sb.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._cellName);
        sb.append(", ");
        sb.append(this._parentPath);
        sb.append(", ");
        sb.append(this._messagePrefix);
        sb.append("]");
        return sb.toString();
    }
}

