/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import diskCacheV111.services.space.message.GetLinkGroupNamesMessage;
import diskCacheV111.vehicles.Message;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkgroupListMsgHandler
implements MessageHandler {
    private static Logger _log = LoggerFactory.getLogger(LinkgroupListMsgHandler.class);
    private static final StatePath LINKGROUPS_PATH = new StatePath("linkgroups");
    private final StateUpdateManager _sum;

    public LinkgroupListMsgHandler(StateUpdateManager sum) {
        this._sum = sum;
    }

    @Override
    public boolean handleMessage(Message messagePayload, long metricLifetime) {
        if (!(messagePayload instanceof GetLinkGroupNamesMessage)) {
            return false;
        }
        if (_log.isInfoEnabled()) {
            _log.info("received linkgroup list msg.");
        }
        GetLinkGroupNamesMessage msg = (GetLinkGroupNamesMessage)messagePayload;
        String[] names = msg.getLinkGroupNames();
        StateUpdate update = null;
        for (String name : names) {
            if (update == null) {
                update = new StateUpdate();
            }
            if (_log.isDebugEnabled()) {
                _log.debug("adding linkgroup: " + name + " lifetime: " + metricLifetime);
            }
            update.appendUpdate(LINKGROUPS_PATH.newChild(name), new StateComposite(metricLifetime));
        }
        if (update != null) {
            this._sum.enqueueUpdate(update);
        } else {
            _log.info("received GetLinkGroupNamesMessage with no linkgroups listed");
        }
        return true;
    }
}

