/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.UOID;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CellMessageHandlerSkel
implements CellMessageAnswerable {
    private static final Logger _log = LoggerFactory.getLogger(CellMessageHandlerSkel.class);
    private static final String SIMPLE_DATE_FORMAT = "MMM d, HH:mm:ss z";
    private static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm'Z'";
    private final MessageMetadataRepository<UOID> _msgMetadataRepo;
    private final StateUpdateManager _sum;
    private String _domain;

    protected static void addTimeMetrics(StateUpdate update, StatePath parentPath, Date theTime, long lifetime) {
        update.appendUpdate(parentPath.newChild("unix"), new IntegerStateValue(theTime.getTime() / 1000L, lifetime));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_DATE_FORMAT);
        iso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        update.appendUpdate(parentPath.newChild("simple"), new StringStateValue(simpleDateFormat.format(theTime), lifetime));
        update.appendUpdate(parentPath.newChild("ISO-8601"), new StringStateValue(iso8601DateFormat.format(theTime), lifetime));
    }

    public CellMessageHandlerSkel(StateUpdateManager sum, MessageMetadataRepository<UOID> msgHandlerChain) {
        this._sum = sum;
        this._msgMetadataRepo = msgHandlerChain;
    }

    public abstract void process(Object var1, long var2);

    protected void addItems(StateUpdate update, StatePath parentPath, Object[] items, long metricLifetime) {
        if (_log.isDebugEnabled()) {
            _log.debug("appending list-items under " + parentPath);
        }
        for (Object item : items) {
            String listItem = (String)item;
            if (_log.isDebugEnabled()) {
                _log.debug("    adding item " + listItem);
            }
            update.appendUpdate(parentPath.newChild(listItem), new StateComposite(metricLifetime));
        }
    }

    protected void applyUpdates(StateUpdate update) {
        if (_log.isDebugEnabled()) {
            _log.debug("adding update to state's to-do stack with " + update.count() + " updates for " + this.getClass().getSimpleName());
        }
        this._sum.enqueueUpdate(update);
    }

    public void answerArrived(CellMessage request, CellMessage answer) {
        Serializable payload = answer.getMessageObject();
        if (payload == null) {
            _log.warn("ignoring incoming message for " + this.getClass().getSimpleName() + " will null payload");
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("incoming CellMessage received from " + answer.getSourcePath());
        }
        long ttl = this._msgMetadataRepo.getMetricTTL(request.getLastUOID());
        this._msgMetadataRepo.remove(request.getLastUOID());
        if (payload instanceof Exception) {
            Exception e = (Exception)payload;
            _log.info("received exception: " + e.getMessage());
            return;
        }
        this._domain = answer.getSourcePath().getCellDomainName();
        this.process(payload, ttl);
    }

    public String getDomain() {
        return this._domain;
    }

    public void exceptionArrived(CellMessage request, Exception exception) {
        if (exception instanceof NoRouteToCellException) {
            _log.info("Sending message to {} failed: {}", (Object)((NoRouteToCellException)((Object)exception)).getDestinationPath(), (Object)exception.getMessage());
        } else {
            _log.error("Received remote exception: {}", (Throwable)exception);
        }
    }

    public void answerTimedOut(CellMessage request) {
        _log.info("Message timed out");
        this._msgMetadataRepo.remove(request.getLastUOID());
    }
}

