/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.Date;
import org.dcache.services.info.base.MetricStatePathException;
import org.dcache.services.info.base.StateComponent;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StatePathPredicate;
import org.dcache.services.info.base.StateTransition;
import org.dcache.services.info.base.StateVisitor;

public abstract class StateValue
implements StateComponent {
    private static final boolean DUMMY_ISEPHEMERAL_VALUE = false;
    private static final int _granularity = 500;
    private static final int _millisecondsInSecond = 1000;
    private final Date _expiryTime;
    private final boolean _isEphemeral;

    protected StateValue(boolean isImmortal) {
        this._expiryTime = null;
        this._isEphemeral = !isImmortal;
    }

    protected StateValue(long duration) {
        if (duration < 0L) {
            duration = 0L;
        }
        long tim = System.currentTimeMillis();
        if (duration > 0L) {
            tim += duration * 1000L;
            tim = Math.round((double)tim / 500.0) * 500L;
        }
        this._expiryTime = new Date(tim);
        this._isEphemeral = false;
    }

    @Override
    public Date getExpiryDate() {
        return this._expiryTime != null ? new Date(this._expiryTime.getTime()) : null;
    }

    @Override
    public boolean hasExpired() {
        if (this._expiryTime == null) {
            return false;
        }
        Date now = new Date();
        return !now.before(this._expiryTime);
    }

    public abstract String getTypeName();

    @Override
    public abstract void acceptVisitor(StatePath var1, StateVisitor var2);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public void acceptVisitor(StateTransition transition, StatePath path, StateVisitor visitor) {
        this.acceptVisitor(path, visitor);
    }

    @Override
    public void applyTransition(StatePath ourPath, StateTransition transition) {
    }

    @Override
    public void buildTransition(StatePath ourPath, StatePath childPath, StateComponent newChild, StateTransition transition) throws MetricStatePathException {
        throw new MetricStatePathException(ourPath.toString());
    }

    @Override
    public void buildRemovalTransition(StatePath ourPath, StateTransition transition, boolean forced) {
    }

    @Override
    public boolean predicateHasBeenTriggered(StatePath ourPath, StatePathPredicate predicate, StateTransition transition) {
        return false;
    }

    @Override
    public void buildPurgeTransition(StateTransition transition, StatePath ourPath, StatePath remainingPath) {
    }

    @Override
    public boolean isMortal() {
        return this._expiryTime != null;
    }

    @Override
    public boolean isEphemeral() {
        return this._expiryTime == null && this._isEphemeral;
    }

    @Override
    public boolean isImmortal() {
        return this._expiryTime == null && !this._isEphemeral;
    }

    @Override
    public Date getEarliestChildExpiryDate() {
        return null;
    }
}

