/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.HashMap;
import java.util.Map;
import org.dcache.services.info.base.StatePath;

public class StatePersistentMetadata {
    private final Map<String, StatePersistentMetadata> _children = new HashMap<String, StatePersistentMetadata>();
    private final Map<String, String> _payload = new HashMap<String, String>();
    private StatePersistentMetadata _wildcard;

    protected StatePersistentMetadata() {
    }

    private StatePersistentMetadata getOrCreateChild(String reference) {
        if (reference.equals("*")) {
            if (this._wildcard == null) {
                this._wildcard = new StatePersistentMetadata();
            }
            return this._wildcard;
        }
        StatePersistentMetadata child = this._children.get(reference);
        if (child == null) {
            child = new StatePersistentMetadata();
            this._children.put(reference, child);
        }
        return child;
    }

    protected StatePersistentMetadata getChild(String name) {
        StatePersistentMetadata child = this._children.get(name);
        if (child == null) {
            child = this._wildcard;
        }
        return child;
    }

    void add(StatePath path, Map<String, String> update) {
        if (update == null) {
            return;
        }
        if (path != null) {
            String pathElement = path.getFirstElement();
            this.getOrCreateChild(pathElement).add(path.childPath(), update);
            return;
        }
        this._payload.putAll(update);
    }

    Map<String, String> getMetadata() {
        return this._payload;
    }

    protected void addDefault() {
        this.add(StatePath.parsePath("domains.*"), this.branchMetadata("domain", "name"));
        this.add(StatePath.parsePath("domains.*.cells.*"), this.branchMetadata("cell", "name"));
        this.add(StatePath.parsePath("domains.*.routing.local.*"), this.branchMetadata("cellref", "name"));
        this.add(StatePath.parsePath("domains.*.routing.named-cells.*"), this.branchMetadata("cell", "name"));
        this.add(StatePath.parsePath("domains.*.routing.named-cells.*.*"), this.branchMetadata("domainref", "name"));
        this.add(StatePath.parsePath("domains.*.routing.remote.*"), this.branchMetadata("domain", "name"));
        this.add(StatePath.parsePath("domains.*.routing.remote.*.*"), this.branchMetadata("cellref", "name"));
        this.add(StatePath.parsePath("pools.*"), this.branchMetadata("pool", "name"));
        this.add(StatePath.parsePath("pools.*.links.*"), this.branchMetadata("linkref", "name"));
        this.add(StatePath.parsePath("pools.*.poolgroups.*"), this.branchMetadata("poolgroupref", "name"));
        this.add(StatePath.parsePath("pools.*.queues.*"), this.branchMetadata("queue", "type"));
        this.add(StatePath.parsePath("pools.*.queues.named-queues.*"), this.branchMetadata("queue", "name"));
        this.add(StatePath.parsePath("poolgroups.*"), this.branchMetadata("poolgroup", "name"));
        this.add(StatePath.parsePath("poolgroups.*.links.*"), this.branchMetadata("linkref", "name"));
        this.add(StatePath.parsePath("poolgroups.*.pools.*"), this.branchMetadata("poolref", "name"));
        this.add(StatePath.parsePath("links.*"), this.branchMetadata("link", "name"));
        this.add(StatePath.parsePath("links.*.poolgroups.*"), this.branchMetadata("poolgroupref", "name"));
        this.add(StatePath.parsePath("links.*.pools.*"), this.branchMetadata("poolref", "name"));
        this.add(StatePath.parsePath("links.*.unitgroups.*"), this.branchMetadata("unitgroupref", "name"));
        this.add(StatePath.parsePath("links.*.units.protocol.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("links.*.units.net.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("links.*.units.store.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("links.*.units.dcache.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("linkgroups.*"), this.branchMetadata("linkgroup", "lgid"));
        this.add(StatePath.parsePath("linkgroups.*.authorisation.*"), this.branchMetadata("authorised", "name"));
        this.add(StatePath.parsePath("linkgroups.*.reservations.*"), this.branchMetadata("reservationref", "reservation-id"));
        this.add(StatePath.parsePath("reservations.*"), this.branchMetadata("reservation", "reservation-id"));
        this.add(StatePath.parsePath("summary.linkgroup.blanket-auth.by-VO.*"), this.branchMetadata("VO", "name"));
        this.add(StatePath.parsePath("summary.linkgroup.blanket-auth.by-VO.*.linkgroups.*"), this.branchMetadata("linkgroupref", "lgid"));
        this.add(StatePath.parsePath("summary.linkgroup.blanket-auth.all.linkgroups.*"), this.branchMetadata("linkgroupref", "lgid"));
        this.add(StatePath.parsePath("summary.reservations.by-VO.*"), this.branchMetadata("VO", "name"));
        this.add(StatePath.parsePath("summary.reservations.by-VO.*.by-description.*"), this.branchMetadata("reservation-group", "description"));
        this.add(StatePath.parsePath("summary.reservations.by-VO.*.by-description.*.reservations.*"), this.branchMetadata("reservation", "id"));
        this.add(StatePath.parsePath("units.*"), this.branchMetadata("unit", "name"));
        this.add(StatePath.parsePath("units.*.unitgroups.*"), this.branchMetadata("unitgroupref", "ref"));
        this.add(StatePath.parsePath("unitgroups.*"), this.branchMetadata("unitgroup", "name"));
        this.add(StatePath.parsePath("unitgroups.*.units.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("unitgroups.*.links.*"), this.branchMetadata("linkref", "name"));
        this.add(StatePath.parsePath("doors.*"), this.branchMetadata("door", "name"));
        this.add(StatePath.parsePath("doors.*.interfaces.*"), this.branchMetadata("interface", "id"));
        this.add(StatePath.parsePath("nas.*"), this.branchMetadata("nas", "id"));
        this.add(StatePath.parsePath("nas.*.links.*"), this.branchMetadata("linkref", "name"));
        this.add(StatePath.parsePath("nas.*.pools.*"), this.branchMetadata("poolref", "name"));
        this.add(StatePath.parsePath("nas.*.units.store.read.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.store.write.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.store.stage.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.dcache.read.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.dcache.write.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.dcache.stage.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.protocol.read.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.protocol.write.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.protocol.stage.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.net.read.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.net.write.*"), this.branchMetadata("unitref", "name"));
        this.add(StatePath.parsePath("nas.*.units.net.stage.*"), this.branchMetadata("unitref", "name"));
    }

    private Map<String, String> branchMetadata(String branchClass, String branchIdName) {
        HashMap<String, String> metadataUpdate = new HashMap<String, String>();
        metadataUpdate.put("branch", branchClass);
        metadataUpdate.put("id", branchIdName);
        return metadataUpdate;
    }
}

