/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.Iterator;
import org.dcache.services.info.base.StatePath;

public class StatePathPredicate
extends StatePath {
    private static final String WILDCARD_ELEMENT = "*";

    public static StatePathPredicate parsePath(String path) {
        if (path == null) {
            return null;
        }
        String[] elements = path.split("\\.");
        return new StatePathPredicate(elements);
    }

    private static boolean elementsMatch(String predicateElement, String pathElement) {
        if (pathElement == null || predicateElement == null) {
            return false;
        }
        if (predicateElement.equals(WILDCARD_ELEMENT)) {
            return true;
        }
        return pathElement.equals(predicateElement);
    }

    public StatePathPredicate(StatePath path) {
        super(path);
    }

    public StatePathPredicate(String path) {
        super(path);
    }

    private StatePathPredicate(String[] elements) {
        super(elements);
    }

    public boolean matches(StatePath path) {
        if (path == null) {
            return false;
        }
        if (path._elements.size() != this._elements.size()) {
            return false;
        }
        Iterator myItr = this._elements.iterator();
        for (String pathElement : path._elements) {
            String myElement = (String)myItr.next();
            if (StatePathPredicate.elementsMatch(myElement, pathElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public StatePathPredicate childPath() {
        StatePath childPath = super.childPath();
        return childPath == null ? null : new StatePathPredicate(childPath);
    }

    public boolean topElementMatches(String name) {
        return StatePathPredicate.elementsMatch((String)this._elements.get(0), name);
    }
}

