/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.ArrayList;
import java.util.List;

public class StatePath {
    private static final int NULL_ELEMENT_HASH = -559038801;
    protected final List<String> _elements;
    private int _myHashCode;
    private boolean _haveHashCode;
    private String _toString;

    public static StatePath parsePath(String path) {
        String[] elements = path.split("\\.");
        return new StatePath(elements);
    }

    protected StatePath(StatePath path) {
        this._elements = new ArrayList<String>(path._elements);
    }

    public static StatePath buildFromList(List<String> pathElements) {
        return new StatePath(pathElements, pathElements.size());
    }

    private StatePath(List<String> elements, int elementCount) {
        this._elements = new ArrayList<String>(elementCount);
        for (String element : elements) {
            this._elements.add(element.intern());
        }
    }

    protected StatePath(String[] elements) {
        this._elements = new ArrayList<String>(elements.length);
        for (String element : elements) {
            this._elements.add(element.intern());
        }
    }

    public StatePath(String element) {
        this._elements = new ArrayList<String>(1);
        this._elements.add(element != null ? element.intern() : null);
    }

    void calcHashCode() {
        int code = 0;
        int elementCount = 0;
        for (String element : this._elements) {
            int stringHash = 0;
            if (element == null) {
                stringHash = -559038801;
            } else {
                byte[] bytes = element.getBytes();
                int len = bytes.length > 10 ? 10 : bytes.length;
                for (int i = 0; i < len; ++i) {
                    stringHash ^= bytes[i] << (i * 5 + elementCount) % 24;
                }
            }
            code ^= stringHash;
            ++elementCount;
        }
        this._myHashCode = code;
        this._haveHashCode = true;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof StatePath)) {
            return false;
        }
        if (otherObject == this) {
            return true;
        }
        StatePath otherPath = (StatePath)otherObject;
        if (otherPath._elements.size() != this._elements.size()) {
            return false;
        }
        for (int i = 0; i < this._elements.size(); ++i) {
            if (otherPath._elements.get(i) == this._elements.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this._haveHashCode) {
            this.calcHashCode();
        }
        return this._myHashCode;
    }

    public boolean equalsOrHasChild(StatePath otherPath) {
        if (otherPath == null) {
            return false;
        }
        if (this._elements.size() > otherPath._elements.size()) {
            return false;
        }
        for (int i = 0; i < this._elements.size(); ++i) {
            if (this._elements.get(i) == otherPath._elements.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isParentOf(StatePath otherPath) {
        if (otherPath == null) {
            return false;
        }
        if (this._elements.size() + 1 != otherPath._elements.size()) {
            return false;
        }
        for (int i = 0; i < this._elements.size(); ++i) {
            if (this._elements.get(i) == otherPath._elements.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = this.toString(".", 0);
        }
        return this._toString;
    }

    public String toString(String separator, int count) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        for (String e : this._elements) {
            if (i >= count) {
                if (i > count) {
                    out.append(separator);
                }
                out.append(e);
            }
            ++i;
        }
        return out.toString();
    }

    public String toString(StatePath prefix) {
        int count = prefix != null ? prefix._elements.size() : 0;
        return this.toString(".", count);
    }

    public String getFirstElement() {
        return this._elements.get(0);
    }

    public String getLastElement() {
        return this._elements.get(this._elements.size() - 1);
    }

    public StatePath newChild(String element) {
        StatePath newPath = new StatePath(this._elements, this._elements.size() + 1);
        newPath._elements.add(element.intern());
        return newPath;
    }

    public StatePath newChild(StatePath subPath) {
        StatePath newPath = new StatePath(this._elements, this._elements.size() + subPath._elements.size());
        newPath._elements.addAll(subPath._elements);
        return newPath;
    }

    public StatePath childPath() {
        if (this._elements == null || this._elements.size() <= 1) {
            return null;
        }
        return new StatePath(this._elements.subList(1, this._elements.size()), this._elements.size() - 1);
    }

    public StatePath parentPath() {
        if (this._elements.size() <= 1) {
            return null;
        }
        return new StatePath(this._elements.subList(0, this._elements.size() - 1), this._elements.size() - 1);
    }

    public boolean isSimplePath() {
        return this._elements.size() == 1;
    }
}

