/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellEndpoint;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.commons.util.NDC;
import org.dcache.services.info.base.StateCaretaker;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.util.FireAndForgetTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMaintainer
implements StateUpdateManager {
    private static final Logger _log = LoggerFactory.getLogger(StateMaintainer.class);
    private static final boolean CANCEL_RUNNING_METRIC_EXPUNGE = false;
    private final ScheduledExecutorService _scheduler;
    private final AtomicInteger _pendingRequestCount = new AtomicInteger();
    private volatile StateCaretaker _caretaker;
    private String _cellName = "unknown";
    private String _domainName = "unknown";
    private ScheduledFuture<?> _metricExpiryFuture;
    private Date _metricExpiryDate;

    public StateMaintainer(StateCaretaker caretaker, ThreadFactory threadFactory) {
        this._caretaker = caretaker;
        this._scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public void setCellEndpoint(CellEndpoint endpoint) {
        this._domainName = endpoint.getCellInfo().getDomainName();
        this._cellName = endpoint.getCellInfo().getCellName();
    }

    void setStateCaretaker(StateCaretaker caretaker) {
        this._caretaker = caretaker;
    }

    @Override
    public int countPendingUpdates() {
        return this._pendingRequestCount.get();
    }

    @Override
    public void enqueueUpdate(final StateUpdate pendingUpdate) {
        if (_log.isDebugEnabled()) {
            _log.debug("enqueing job to process update " + pendingUpdate);
        }
        final NDC ndc = NDC.cloneNdc();
        this._pendingRequestCount.incrementAndGet();
        this._scheduler.execute(new FireAndForgetTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CDC.reset((String)StateMaintainer.this._cellName, (String)StateMaintainer.this._domainName);
                NDC.set((NDC)ndc);
                try {
                    if (_log.isDebugEnabled()) {
                        _log.debug("starting job to process update " + pendingUpdate);
                    }
                    StateMaintainer.this._caretaker.processUpdate(pendingUpdate);
                    StateMaintainer.this.checkScheduledExpungeActivity();
                    if (_log.isDebugEnabled()) {
                        _log.debug("finished job to process update " + pendingUpdate);
                    }
                }
                finally {
                    StateMaintainer.this._pendingRequestCount.decrementAndGet();
                    CDC.clear();
                }
            }
        }));
    }

    @Override
    public void shutdown() {
        List<Runnable> unprocessed = this._scheduler.shutdownNow();
        if (!unprocessed.isEmpty()) {
            _log.info("Shutting down with " + unprocessed.size() + " pending updates");
        } else {
            _log.debug("Shutting down without any pending updates");
        }
    }

    synchronized void checkScheduledExpungeActivity() {
        Date earliestMetricExpiry = this._caretaker.getEarliestMetricExpiryDate();
        if (earliestMetricExpiry == null && this._metricExpiryDate == null) {
            return;
        }
        if (this._metricExpiryDate != null && !this._metricExpiryDate.equals(earliestMetricExpiry)) {
            if (_log.isDebugEnabled()) {
                Date now = new Date();
                long delay = this._metricExpiryDate.getTime() - now.getTime();
                _log.debug("Cancelling existing metric purge, due to take place in " + (double)delay / 1000.0 + " s");
            }
            if (this._metricExpiryFuture.cancel(false)) {
                this._metricExpiryDate = null;
            }
        }
        if (this._metricExpiryDate == null) {
            this.scheduleMetricExpunge(earliestMetricExpiry);
        }
    }

    private synchronized void scheduleMetricExpunge(Date whenExpunge) {
        this._metricExpiryDate = whenExpunge;
        if (whenExpunge == null) {
            this._metricExpiryFuture = null;
            return;
        }
        long delay = whenExpunge.getTime() - System.currentTimeMillis();
        if (_log.isDebugEnabled()) {
            _log.debug("Scheduling next metric purge in " + (double)delay / 1000.0 + " s");
        }
        try {
            this._metricExpiryFuture = this._scheduler.schedule(new FireAndForgetTask(new Runnable(){

                @Override
                public void run() {
                    _log.debug("Starting metric purge");
                    StateMaintainer.this._caretaker.removeExpiredMetrics();
                    StateMaintainer.this.scheduleMetricExpunge();
                    _log.debug("Metric purge completed");
                }
            }), delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            _log.debug("Failed to enqueue expunge task as queue is not accepting further work.");
        }
    }

    protected synchronized void scheduleMetricExpunge() {
        this.scheduleMetricExpunge(this._caretaker.getEarliestMetricExpiryDate());
    }
}

