/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.StateComponent;

public class StateChangeSet {
    final Map<String, StateComponent> _newChildren = new HashMap<String, StateComponent>();
    final Map<String, StateComponent> _updatedChildren = new HashMap<String, StateComponent>();
    final Set<String> _removedChildren = new HashSet<String>();
    final Set<String> _itrChildren = new HashSet<String>();
    Date _whenIShouldExpire;
    boolean _hasImmortalChildren;

    protected void recordNewChild(String childName, StateComponent value) {
        this.purgeChildEntries(childName);
        this._newChildren.put(childName, value);
    }

    protected void recordUpdatedChild(String childName, StateComponent value) {
        this.purgeChildEntries(childName);
        this._updatedChildren.put(childName, value);
    }

    protected void recordRemovedChild(String childName) {
        this.purgeChildEntries(childName);
        this._removedChildren.add(childName);
    }

    protected void recordChildIsImmortal() {
        this._hasImmortalChildren = true;
    }

    protected void recordNewWhenIShouldExpireDate(Date childExpiryDate) {
        if (childExpiryDate == null) {
            return;
        }
        if (this._whenIShouldExpire == null || childExpiryDate.after(this._whenIShouldExpire)) {
            this._whenIShouldExpire = childExpiryDate;
        }
    }

    protected Date getWhenIShouldExpireDate() {
        return this._whenIShouldExpire;
    }

    protected void recordChildItr(String childName) {
        this._itrChildren.add(childName);
    }

    protected Set<String> getItrChildren() {
        return this._itrChildren;
    }

    protected boolean hasChildChanged(String childName) {
        return this._itrChildren.contains(childName) || this._newChildren.containsKey(childName) || this._updatedChildren.containsKey(childName) || this._removedChildren.contains(childName);
    }

    protected boolean haveImmortalChild() {
        return this._hasImmortalChildren;
    }

    protected boolean childIsRemoved(String name) {
        return this._removedChildren.contains(name);
    }

    protected boolean childIsUpdated(String name) {
        return this._updatedChildren.containsKey(name);
    }

    protected void ensureChildNotRemoved(String childName) {
        this._removedChildren.remove(childName);
    }

    protected boolean childIsNew(String name) {
        return this._newChildren.containsKey(name);
    }

    protected StateComponent getFreshChildValue(String childName) {
        StateComponent newValue = this._newChildren.get(childName);
        return newValue != null ? newValue : this._updatedChildren.get(childName);
    }

    protected Set<String> getNewChildren() {
        return this._newChildren.keySet();
    }

    protected Set<String> getRemovedChildren() {
        return this._removedChildren;
    }

    protected Collection<String> getUpdatedChildren() {
        return this._updatedChildren.keySet();
    }

    protected StateComponent getUpdatedChildValue(String childName) {
        return this._updatedChildren.get(childName);
    }

    protected StateComponent getNewChildValue(String childName) {
        return this._newChildren.get(childName);
    }

    protected String dumpContents() {
        StringBuilder sb = new StringBuilder();
        sb.append("  new:\n");
        for (Map.Entry<String, StateComponent> newEntry : this._newChildren.entrySet()) {
            sb.append("    ");
            sb.append(newEntry.getKey());
            sb.append(" --> ");
            sb.append(newEntry.getValue().toString());
            sb.append("\n");
        }
        sb.append("  update:\n");
        for (Map.Entry<String, StateComponent> updateEntry : this._updatedChildren.entrySet()) {
            sb.append("    ");
            sb.append(updateEntry.getKey());
            sb.append(" --> ");
            sb.append(updateEntry.getValue().toString());
            sb.append("\n");
        }
        sb.append("  remove:\n");
        for (String childName : this._removedChildren) {
            sb.append("    ");
            sb.append(childName);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void purgeChildEntries(String childName) {
        this._newChildren.remove(childName);
        this._updatedChildren.remove(childName);
        this._removedChildren.remove(childName);
    }
}

