/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.BooleanStateValue;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateChangeSet;
import org.dcache.services.info.base.StateComponent;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateTransition;
import org.dcache.services.info.base.StateValue;
import org.dcache.services.info.base.StateVisitor;
import org.dcache.services.info.base.StringStateValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostTransitionStateExhibitor
implements StateExhibitor {
    private static final Logger _log = LoggerFactory.getLogger(PostTransitionStateExhibitor.class);
    private final StateTransition _transition;
    private final StateExhibitor _currentStateExhibitor;

    public PostTransitionStateExhibitor(StateExhibitor exhibitor, StateTransition transition) {
        this._currentStateExhibitor = exhibitor;
        this._transition = transition;
    }

    @Override
    public void visitState(StateVisitor visitor) {
        PreTransitionVisitor preTransitionVisitor = new PreTransitionVisitor(visitor);
        this._currentStateExhibitor.visitState(preTransitionVisitor);
    }

    private class PreTransitionVisitor
    implements StateVisitor {
        private final StateVisitor _postTransitionVisitor;
        private final Set<StatePath> _bannedSubtrees = new HashSet<StatePath>();

        public PreTransitionVisitor(StateVisitor postTransitionVisitor) {
            this._postTransitionVisitor = postTransitionVisitor;
        }

        @Override
        public void visitBoolean(StatePath path, BooleanStateValue value) {
            if (this.isMetricUpdatedOrDeleted(path)) {
                this.visitUpdatedOrDeletedMetric(path, value);
            } else {
                this._postTransitionVisitor.visitBoolean(path, value);
            }
        }

        @Override
        public void visitFloatingPoint(StatePath path, FloatingPointStateValue value) {
            if (this.isMetricUpdatedOrDeleted(path)) {
                this.visitUpdatedOrDeletedMetric(path, value);
            } else {
                this._postTransitionVisitor.visitFloatingPoint(path, value);
            }
        }

        @Override
        public void visitInteger(StatePath path, IntegerStateValue value) {
            if (this.isMetricUpdatedOrDeleted(path)) {
                this.visitUpdatedOrDeletedMetric(path, value);
            } else {
                this._postTransitionVisitor.visitInteger(path, value);
            }
        }

        @Override
        public void visitString(StatePath path, StringStateValue value) {
            if (this.isMetricUpdatedOrDeleted(path)) {
                this.visitUpdatedOrDeletedMetric(path, value);
            } else {
                this._postTransitionVisitor.visitString(path, value);
            }
        }

        private boolean isMetricUpdatedOrDeleted(StatePath metricPath) {
            StatePath parentPath = metricPath.parentPath();
            String metricName = metricPath.getLastElement();
            StateChangeSet scs = PostTransitionStateExhibitor.this._transition.getStateChangeSet(parentPath);
            boolean isRemoved = scs != null && scs.childIsRemoved(metricName);
            boolean isUpdated = scs != null && scs.childIsUpdated(metricName);
            return isRemoved || isUpdated || this.hasBannedParent(metricPath);
        }

        private void visitUpdatedOrDeletedMetric(StatePath path, StateValue value) {
            _log.debug("path={}  value={}", (Object)path, (Object)value);
            StatePath parentPath = path.parentPath();
            String name = path.getLastElement();
            StateChangeSet scs = PostTransitionStateExhibitor.this._transition.getStateChangeSet(parentPath);
            if (scs != null && scs.childIsUpdated(name)) {
                StateComponent updatedComponent = scs.getUpdatedChildValue(name);
                this.visitUpdatedMetricValue(path, updatedComponent);
            }
        }

        private void visitUpdatedMetricValue(StatePath path, StateComponent component) {
            _log.debug("path={}  component={}", (Object)path, (Object)component);
            if (component instanceof StateComposite) {
                component.acceptVisitor(path, this);
            } else {
                component.acceptVisitor(path, this._postTransitionVisitor);
            }
        }

        @Override
        public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
            if (path == null) {
                this._postTransitionVisitor.visitCompositePreDescend(null, metadata);
                return;
            }
            StatePath parentPath = path.parentPath();
            String componentName = path.getLastElement();
            StateChangeSet scs = PostTransitionStateExhibitor.this._transition.getStateChangeSet(parentPath);
            if (scs != null && scs.childIsRemoved(componentName)) {
                this.banChildrenOf(path);
                return;
            }
            if (scs != null && scs.childIsUpdated(componentName)) {
                StateComponent updatedComponent = scs.getUpdatedChildValue(componentName);
                this.visitUpdatedStateComponentPreDescend(path, updatedComponent, metadata);
            } else {
                this._postTransitionVisitor.visitCompositePreDescend(path, metadata);
            }
        }

        private void visitUpdatedStateComponentPreDescend(StatePath path, StateComponent updatedComponent, Map<String, String> metadata) {
            if (updatedComponent instanceof StateComposite) {
                this._postTransitionVisitor.visitCompositePreDescend(path, metadata);
            } else {
                updatedComponent.acceptVisitor(path, this._postTransitionVisitor);
                this.banChildrenOf(path);
            }
        }

        private void banChildrenOf(StatePath parentPath) {
            this._bannedSubtrees.add(parentPath);
        }

        private boolean hasBannedParent(StatePath path) {
            for (StatePath bannedParent : this._bannedSubtrees) {
                if (!bannedParent.isParentOf(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitCompositePostDescend(StatePath path, Map<String, String> metadata) {
            if (!this.shouldPostVisitComposite(path)) {
                return;
            }
            this.visitNewChildren(path);
            this._postTransitionVisitor.visitCompositePostDescend(path, metadata);
        }

        private boolean shouldPostVisitComposite(StatePath path) {
            if (path == null) {
                return true;
            }
            StatePath parentPath = path.parentPath();
            StateChangeSet parentScs = PostTransitionStateExhibitor.this._transition.getStateChangeSet(parentPath);
            if (parentScs != null) {
                StateComponent updatedComponent;
                String branchName = path.getLastElement();
                if (parentScs.childIsRemoved(branchName)) {
                    return false;
                }
                if (parentScs.childIsUpdated(branchName) && (updatedComponent = parentScs.getUpdatedChildValue(branchName)) instanceof StateValue) {
                    return false;
                }
            }
            return true;
        }

        private void visitNewChildren(StatePath compositePath) {
            StateChangeSet thisBranchScs = PostTransitionStateExhibitor.this._transition.getStateChangeSet(compositePath);
            if (thisBranchScs == null) {
                return;
            }
            for (String newChildName : thisBranchScs.getNewChildren()) {
                StatePath childPath = compositePath != null ? compositePath.newChild(newChildName) : new StatePath(newChildName);
                StateComponent newComponent = thisBranchScs.getNewChildValue(newChildName);
                this.visitNewChild(childPath, newComponent);
            }
        }

        private void visitNewChild(StatePath path, StateComponent component) {
            _log.debug("Visiting new child: {}", (Object)path);
            if (component instanceof StateComposite) {
                component.acceptVisitor(path, this);
            } else {
                component.acceptVisitor(path, this._postTransitionVisitor);
            }
        }

        @Override
        public boolean isVisitable(StatePath path) {
            if (this.hasBannedParent(path)) {
                return false;
            }
            return this._postTransitionVisitor.isVisitable(path);
        }
    }
}

