/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info;

import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import org.dcache.cells.AbstractCell;
import org.dcache.services.info.base.BadStatePathException;
import org.dcache.services.info.base.State;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StateMaintainer;
import org.dcache.services.info.base.StateObservatory;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.conduits.Conduit;
import org.dcache.services.info.conduits.XmlConduit;
import org.dcache.services.info.gathers.DataGatheringScheduler;
import org.dcache.services.info.gathers.MessageHandlerChain;
import org.dcache.services.info.secondaryInfoProviders.LinkSpaceMaintainer;
import org.dcache.services.info.secondaryInfoProviders.LinkgroupTotalSpaceMaintainer;
import org.dcache.services.info.secondaryInfoProviders.NormalisedAccessSpaceMaintainer;
import org.dcache.services.info.secondaryInfoProviders.PoolgroupSpaceWatcher;
import org.dcache.services.info.secondaryInfoProviders.PoolsSummaryMaintainer;
import org.dcache.services.info.secondaryInfoProviders.ReservationByDescMaintainer;
import org.dcache.services.info.serialisation.PrettyPrintTextSerialiser;
import org.dcache.services.info.serialisation.SimpleTextSerialiser;
import org.dcache.services.info.serialisation.StateSerialiser;
import org.dcache.services.info.serialisation.XmlSerialiser;
import org.dcache.vehicles.InfoGetSerialisedDataMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoProvider
extends AbstractCell {
    private static Logger _log = LoggerFactory.getLogger(InfoProvider.class);
    private static final String ADMIN_INTERFACE_OK = "Done.";
    private static final String ADMIN_INTERFACE_NONE = "(none)";
    private static final String ADMIN_INTERFACE_LIST_PREFIX = "  ";
    private static final String TOPLEVEL_DIRECTORY_LABEL = "(top)";
    private static final String DEFAULT_SERIALISER_NAME = "simple";
    private Map<String, Conduit> _conduits;
    private DataGatheringScheduler _scheduler;
    private MessageHandlerChain _msgHandlerChain;
    private StateSerialiser _currentSerialiser;
    private Map<String, StateSerialiser> _availableSerialisers;
    private StatePath _startSerialisingFrom;
    private final State _state = new State();
    private final StateObservatory _observatory = this._state;
    private final StateUpdateManager _sum;
    public static final String fh_handler_ls = "List all known Message handlers.  These are responsible for updating dCache state.";
    public static final String hh_handler_ls = "";
    public static final String fh_conduits_ls = "List all known conduits.  Conduits provide read-only access to dCache current state.";
    public static final String fh_conduits_enable = "Enabled the named conduit.";
    public static final String hh_conduits_enable = "<conduit name>";
    public static final String fh_conduits_disable = "Disable the named conduit.";
    public static final String hh_conduits_disable = "<conduit name>";
    public static final String fh_dga_ls = "list all known data-gathering activity, whether enabled or not.";
    public static final String hh_dga_disable = "<name>";
    public static final String fh_dga_disable = "disable a data-gathering activity.";
    public static final String hh_dga_enable = "<name>";
    public static final String fh_dga_enable = "enable a data-gathering activity.  The next trigger time is randomly chosen.";
    public static final String hh_dga_trigger = "<name>";
    public static final String fh_dga_trigger = "trigger data-gathering activity <name> now.";
    public static final String fh_state_ls = "List current status of dCache";
    public static final String hh_state_ls = "[<path>]";
    public static final String fh_state_output = "view or change output format for the \"state ls\" command.";
    public static final String hh_state_output = "[<format>]";
    public static final String fh_state_pwd = "List the current directory for state ls";
    public static final String fh_state_cd = "Change directory for state ls; path elements must be slash-separated";
    public static final String hh_state_cd = "<path>";
    public static final String fh_watchers_ls = "list all registered dCache state watchers";
    public static final String fh_watchers_enable = "enable a registered dCache state watcher";
    public static final String fh_watchers_disable = "disable a registered dCache state watcher";

    public void getInfo(PrintWriter pw) {
        pw.println("    Overview of the info cell:\n");
        pw.print(this._conduits.size());
        pw.print(" conduit" + (this._conduits.size() == 1 ? hh_handler_ls : "s") + " (");
        int count = 0;
        for (Conduit c : this._conduits.values()) {
            count += c.isEnabled() ? 1 : 0;
        }
        pw.print(count);
        pw.println(" enabled)");
        pw.print(this._scheduler.listActivity().size());
        pw.println(" data-gathering activities.");
        pw.print(this._availableSerialisers.size());
        pw.println(" available serialisers.");
        this._state.getInfo(pw);
    }

    public InfoProvider(String cellName, String args) throws InterruptedException, ExecutionException {
        super(cellName, args);
        StateMaintainer maintainer = new StateMaintainer(this._state, (ThreadFactory)this.getNucleus());
        maintainer.setCellEndpoint((CellEndpoint)this);
        this._sum = maintainer;
        this.doInit();
    }

    @Override
    public void init() {
        _log.info("InfoProvider starting...");
        this._state.setStateUpdateManager(this._sum);
        State exhibitor = this._state;
        this._availableSerialisers = new HashMap<String, StateSerialiser>();
        this.addSerialiser(new XmlSerialiser(exhibitor));
        this.addSerialiser(new SimpleTextSerialiser(exhibitor));
        this.addSerialiser(new PrettyPrintTextSerialiser(exhibitor));
        this._currentSerialiser = this._availableSerialisers.get(DEFAULT_SERIALISER_NAME);
        this.buildMessageHandlerChain();
        this.startDgaScheduler(exhibitor);
        this.addDefaultConduits(exhibitor);
        this.addDefaultWatchers();
        this.startConduits();
    }

    @Override
    public void cleanUp() {
        this.stopConduits();
        this._scheduler.shutdown();
        this._sum.shutdown();
    }

    void startConduits() {
        for (Conduit conduit : this._conduits.values()) {
            conduit.enable();
        }
    }

    void addDefaultConduits(StateExhibitor exhibitor) {
        this._conduits = new HashMap<String, Conduit>();
        XmlConduit con = new XmlConduit(exhibitor);
        this._conduits.put(((Object)con).toString(), con);
    }

    void stopConduits() {
        for (Conduit conduit : this._conduits.values()) {
            conduit.disable();
        }
    }

    private String enableConduit(String name) {
        Conduit con = this._conduits.get(name);
        if (con == null) {
            return "Conduit " + name + " was not found.";
        }
        if (con.isEnabled()) {
            return "Conduit " + name + " is already enabled.";
        }
        con.enable();
        return null;
    }

    private String disableConduit(String name) {
        Conduit con = this._conduits.get(name);
        if (con == null) {
            return "Conduit " + name + " was not found.";
        }
        if (!con.isEnabled()) {
            return "Conduit " + name + " is not currently enabled.";
        }
        con.disable();
        return null;
    }

    void startDgaScheduler(StateExhibitor exhibitor) {
        this._scheduler = new DataGatheringScheduler(this._sum);
        this._scheduler.addActivity(exhibitor, this._msgHandlerChain, this._msgHandlerChain);
        Thread ict = new Thread(this._scheduler);
        ict.setName("DGA-Scheduler");
        ict.start();
    }

    private void buildMessageHandlerChain() {
        this._msgHandlerChain = new MessageHandlerChain(this._sum, (CellEndpoint)this);
        this._msgHandlerChain.addDefaultHandlers();
    }

    @Override
    public synchronized void messageArrived(CellMessage msg) {
        if (msg.getMessageObject() instanceof InfoGetSerialisedDataMessage) {
            this.addSerialisedDataToMsg((InfoGetSerialisedDataMessage)msg.getMessageObject());
            msg.revertDirection();
            try {
                super.sendMessage(msg);
            }
            catch (NoRouteToCellException e) {
                _log.warn("can't send reply message to " + msg.getDestinationPath() + " : " + e.getMessage());
            }
            return;
        }
        _log.debug("Unable to handle incoming message: {}", (Object)msg);
    }

    public void sendMessage(CellMessage msg) {
        try {
            super.sendMessage(msg);
        }
        catch (NoRouteToCellException e) {
            _log.info("Cannot route message to cell, refraining from delivering msg.", (Throwable)e);
        }
    }

    private void addSerialiser(StateSerialiser serialiser) {
        this._availableSerialisers.put(serialiser.getName(), serialiser);
    }

    private void addDefaultWatchers() {
        this._observatory.addStateWatcher(new PoolgroupSpaceWatcher());
        this._observatory.addStateWatcher(new PoolsSummaryMaintainer());
        this._observatory.addStateWatcher(new LinkgroupTotalSpaceMaintainer());
        this._observatory.addStateWatcher(new LinkSpaceMaintainer());
        this._observatory.addStateWatcher(new NormalisedAccessSpaceMaintainer());
        this._observatory.addStateWatcher(new ReservationByDescMaintainer());
    }

    public String ac_handler_ls_$_0(Args args) {
        StringBuilder sb = new StringBuilder();
        sb.append("Incoming Message Handlers:\n");
        String[] msgHandlers = this._msgHandlerChain.listMessageHandlers();
        if (msgHandlers.length > 0) {
            for (String msgHandler : msgHandlers) {
                sb.append(ADMIN_INTERFACE_LIST_PREFIX);
                sb.append(msgHandler);
                sb.append("\n");
            }
        } else {
            sb.append(ADMIN_INTERFACE_LIST_PREFIX);
            sb.append(ADMIN_INTERFACE_NONE);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String ac_conduits_ls_$_0(Args args) {
        StringBuilder sb = new StringBuilder();
        sb.append("Conduits:\n");
        if (this._conduits.size() > 0) {
            for (Conduit con : this._conduits.values()) {
                sb.append(ADMIN_INTERFACE_LIST_PREFIX);
                sb.append(con.toString());
                sb.append(ADMIN_INTERFACE_LIST_PREFIX);
                sb.append(con.getInfo());
                sb.append("\n");
            }
        } else {
            sb.append(ADMIN_INTERFACE_LIST_PREFIX);
            sb.append(ADMIN_INTERFACE_NONE);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String ac_conduits_enable_$_1(Args args) {
        String errMsg = this.enableConduit(args.argv(0));
        return errMsg == null ? ADMIN_INTERFACE_OK : errMsg;
    }

    public String ac_conduits_disable_$_1(Args args) {
        String errMsg = this.disableConduit(args.argv(0));
        return errMsg == null ? ADMIN_INTERFACE_OK : errMsg;
    }

    public String ac_dga_ls_$_0(Args args) {
        StringBuilder sb = new StringBuilder();
        sb.append("Data-Gathering Activity:\n");
        List<String> dgaList = this._scheduler.listActivity();
        if (dgaList.size() > 0) {
            for (String activity : dgaList) {
                sb.append(ADMIN_INTERFACE_LIST_PREFIX);
                sb.append(activity);
                sb.append("\n");
            }
        } else {
            sb.append(ADMIN_INTERFACE_LIST_PREFIX);
            sb.append(ADMIN_INTERFACE_NONE);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String ac_dga_disable_$_1(Args args) {
        String errMsg = this._scheduler.disableActivity(args.argv(0));
        return errMsg == null ? ADMIN_INTERFACE_OK : errMsg;
    }

    public String ac_dga_enable_$_1(Args args) {
        String errMsg = this._scheduler.enableActivity(args.argv(0));
        return errMsg == null ? ADMIN_INTERFACE_OK : errMsg;
    }

    public String ac_dga_trigger_$_1(Args args) {
        String errMsg = this._scheduler.triggerActivity(args.argv(0));
        return errMsg == null ? ADMIN_INTERFACE_OK : errMsg;
    }

    public String ac_state_ls_$_0_1(Args args) {
        StringBuilder sb = new StringBuilder();
        StatePath start = this._startSerialisingFrom;
        if (args.argc() == 1) {
            try {
                start = this.processPath(this._startSerialisingFrom, args.argv(0));
            }
            catch (BadStatePathException e) {
                return e.toString();
            }
        }
        sb.append("\n");
        if (start != null) {
            sb.append(this._currentSerialiser.serialise(start));
        } else {
            sb.append(this._currentSerialiser.serialise());
        }
        if (sb.length() > 1) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public String ac_state_output_$_0_1(Args args) {
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            sb.append("Current output: ");
            sb.append(this._currentSerialiser.getName());
            sb.append("\n");
            sb.append(this.list_valid_output());
        } else {
            StateSerialiser newSerialiser = this._availableSerialisers.get(args.argv(0));
            if (newSerialiser != null) {
                this._currentSerialiser = newSerialiser;
                sb.append("Will use ");
                sb.append(this._currentSerialiser.getName());
                sb.append(" formatting for future output.");
            } else {
                sb.append("Unknown output format \"");
                sb.append(args.argv(0));
                sb.append("\".\n");
                sb.append(this.list_valid_output());
            }
        }
        return sb.toString();
    }

    private String list_valid_output() {
        StringBuilder sb = new StringBuilder();
        sb.append("Valid output format");
        sb.append(this._availableSerialisers.size() > 1 ? "s are" : " is");
        sb.append(": ");
        Iterator<String> itr = this._availableSerialisers.keySet().iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            if (!itr.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String ac_state_pwd_$_0(Args args) {
        StringBuilder sb = new StringBuilder();
        if (this._startSerialisingFrom != null) {
            sb.append(this._startSerialisingFrom.toString());
        } else {
            sb.append(TOPLEVEL_DIRECTORY_LABEL);
        }
        return sb.toString();
    }

    public String ac_state_cd_$_1(Args args) {
        StatePath newPath;
        try {
            newPath = this.processPath(this._startSerialisingFrom, args.argv(0));
        }
        catch (BadStatePathException e) {
            return e.toString();
        }
        this._startSerialisingFrom = newPath;
        StringBuilder sb = new StringBuilder();
        sb.append("Path now: ");
        sb.append(this.ac_state_pwd_$_0(null));
        return sb.toString();
    }

    private StatePath processPath(StatePath cwd, String path) throws BadStatePathException {
        String element;
        String[] pathElements;
        StatePath currentPath = cwd;
        boolean quoted = false;
        if (path.startsWith("\"") && path.endsWith("\"")) {
            pathElements = new String[1];
            pathElements[1] = path.substring(1, path.length() - 2);
            quoted = true;
        } else {
            if (path.startsWith("/")) {
                currentPath = null;
            }
            pathElements = path.split("/");
        }
        if (!(quoted || pathElements.length != 1 || (element = pathElements[0]).contains("/") || !element.contains(".") || element.equals(".") || element.equals(".."))) {
            currentPath = currentPath != null ? currentPath.newChild(StatePath.parsePath(element)) : StatePath.parsePath(element);
            return currentPath;
        }
        block8: for (int i = 0; i < pathElements.length; ++i) {
            switch (pathElements[i]) {
                case "..": {
                    if (currentPath != null) {
                        currentPath = currentPath.parentPath();
                        continue block8;
                    }
                    throw new BadStatePathException("You cannot cd upward from the top-most element.");
                }
                case ".": {
                    continue block8;
                }
                default: {
                    if (pathElements[i].length() > 0) {
                        if (currentPath == null) {
                            currentPath = new StatePath(pathElements[i]);
                            continue block8;
                        }
                        currentPath = currentPath.newChild(pathElements[i]);
                        continue block8;
                    }
                    if (i == 0) {
                        currentPath = null;
                        continue block8;
                    }
                    throw new BadStatePathException("Path contains zero-length elements.");
                }
            }
        }
        return currentPath;
    }

    public String ac_watchers_ls_$_0(Args args) {
        StringBuilder sb = new StringBuilder();
        sb.append("State Watchers:\n");
        String[] watcherNames = this._observatory.listStateWatcher();
        if (watcherNames.length > 0) {
            for (String name : watcherNames) {
                sb.append(ADMIN_INTERFACE_LIST_PREFIX);
                sb.append(name);
                sb.append("\n");
            }
        } else {
            sb.append(ADMIN_INTERFACE_LIST_PREFIX);
            sb.append(ADMIN_INTERFACE_NONE);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String ac_watchers_enable_$_1(Args args) {
        int count = this._observatory.enableStateWatcher(args.argv(0));
        switch (count) {
            case 0: {
                return "No matching watcher: " + args.argv(0);
            }
            case 1: {
                return ADMIN_INTERFACE_OK;
            }
        }
        return "Name matching multiple Watchers, all now enabled.";
    }

    public String ac_watchers_disable_$_1(Args args) {
        int count = this._observatory.disableStateWatcher(args.argv(0));
        switch (count) {
            case 0: {
                return "No matching watcher: " + args.argv(0);
            }
            case 1: {
                return ADMIN_INTERFACE_OK;
            }
        }
        return "Name matching multiple Watchers, all now disabled.";
    }

    private void addSerialisedDataToMsg(InfoGetSerialisedDataMessage msg) {
        String data;
        StateSerialiser xmlSerialiser;
        if (_log.isInfoEnabled()) {
            _log.info("Received InfoGetSerialisedDataMessage.");
        }
        if ((xmlSerialiser = this._availableSerialisers.get("xml")) != null) {
            data = msg.isCompleteDump() ? xmlSerialiser.serialise() : xmlSerialiser.serialise(StatePath.buildFromList(msg.getPathElements()));
        } else {
            _log.error("Couldn't find the xmlSerialiser");
            data = null;
        }
        msg.setData(data);
    }
}

