/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info;

import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import dmg.util.HttpResponseEngine;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.dcache.vehicles.InfoGetSerialisedDataMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoHttpEngine
implements HttpResponseEngine {
    private static Logger _log = LoggerFactory.getLogger(HttpResponseEngine.class);
    private static final String INFO_CELL_NAME = "info";
    private static final long MAX_CACHE_AGE = 1000L;
    private static final long INFO_CELL_TIMEOUT = 4000L;
    private final CellPath _infoCellPath = new CellPath("info");
    private final CellEndpoint _endpoint;
    private byte[] _cache;
    private Date _whenReceived;

    public InfoHttpEngine(CellEndpoint endpoint, String[] args) {
        if (_log.isInfoEnabled()) {
            _log.info("in InfoHttpEngine constructor");
        }
        this._endpoint = endpoint;
    }

    public void queryUrl(HttpRequest request) throws HttpException {
        byte[] recv;
        ArrayList<String> pathElements = null;
        String[] urlItems = request.getRequestTokens();
        OutputStream out = request.getOutputStream();
        if (_log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (String urlItem : urlItems) {
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(urlItem);
            }
            _log.info("Received request for: " + sb.toString());
        }
        if (urlItems.length > 1) {
            pathElements = new ArrayList<String>(urlItems.length - 1);
            for (int i = 1; i < urlItems.length; ++i) {
                pathElements.add(i - 1, urlItems[i]);
            }
        }
        try {
            if (pathElements == null) {
                if (this._whenReceived == null || System.currentTimeMillis() - this._whenReceived.getTime() > 1000L) {
                    this.updateXMLCache();
                }
                recv = this._cache;
            } else {
                recv = this.fetchXML(pathElements);
            }
        }
        catch (TimeoutException e) {
            throw new HttpException(503, "The info cell took too long to reply, suspect trouble.");
        }
        catch (NotSerializableException e) {
            throw new HttpException(500, "Internal error when requesting info from info cell.");
        }
        catch (NoRouteToCellException e) {
            throw new HttpException(503, "Unable to contact the info cell.  Please ensure the info cell is running.");
        }
        catch (NullPointerException e) {
            throw new HttpException(500, "Received no sensible reply from info cell.  See info cell for details.");
        }
        catch (InterruptedException e) {
            throw new HttpException(503, "Received interrupt whilst processing data. Please try again later.");
        }
        request.setContentType("application/xml");
        try {
            request.printHttpHeader(recv.length);
            out.write(recv);
        }
        catch (IOException e) {
            _log.error("IOException caught whilst writing output : " + e.getMessage());
        }
    }

    public void startup() {
    }

    public void shutdown() {
    }

    public void updateXMLCache() throws InterruptedException, NotSerializableException, NoRouteToCellException, TimeoutException {
        this._cache = this.fetchXML(null);
        this._whenReceived = new Date();
    }

    private byte[] fetchXML(List<String> pathElements) throws InterruptedException, NotSerializableException, NoRouteToCellException, TimeoutException {
        String serialisedData;
        if (_log.isDebugEnabled()) {
            _log.debug("Attempting to fetch XML +" + (pathElements == null ? "complete" : "partial") + " tree");
        }
        InfoGetSerialisedDataMessage sendMsg = pathElements == null ? new InfoGetSerialisedDataMessage() : new InfoGetSerialisedDataMessage(pathElements);
        CellMessage envelope = new CellMessage(this._infoCellPath, (Serializable)sendMsg);
        try {
            CellMessage replyMsg = this._endpoint.sendAndWait(envelope, 4000L);
            if (replyMsg == null) {
                throw new TimeoutException();
            }
            Serializable replyObj = replyMsg.getMessageObject();
            if (replyObj instanceof NoRouteToCellException) {
                throw (NoRouteToCellException)((Object)replyObj);
            }
            if (!(replyObj instanceof InfoGetSerialisedDataMessage)) {
                throw new NotSerializableException();
            }
            InfoGetSerialisedDataMessage reply = (InfoGetSerialisedDataMessage)replyObj;
            serialisedData = reply.getSerialisedData();
            if (serialisedData == null) {
                throw new NullPointerException();
            }
        }
        catch (InterruptedException e) {
            this._cache = null;
            this._whenReceived = null;
            throw e;
        }
        return serialisedData.getBytes();
    }
}

