/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import dmg.protocols.kerberos.Base64;
import dmg.util.CollectionFactory;
import dmg.util.HttpRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardHttpRequest
implements HttpRequest {
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private static final Logger logger = LoggerFactory.getLogger(StandardHttpRequest.class);
    private final OutputStream out;
    private final PrintWriter pw;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Map<String, String> map = CollectionFactory.newHashMap();
    private final int tokenOffset;
    private final String[] tokens;
    private final boolean isDirectory;
    private String userName;
    private String password;
    private boolean authDone;

    public StandardHttpRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        this.request = request;
        this.response = response;
        this.out = response.getOutputStream();
        this.pw = new PrintWriter(new OutputStreamWriter(this.out));
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.map.put(name, request.getHeader(name));
        }
        String path = new URI(request.getRequestURI()).getPath();
        this.isDirectory = path.endsWith("/");
        this.tokens = (String[])Iterables.toArray((Iterable)PATH_SPLITTER.split((CharSequence)path), String.class);
        this.tokenOffset = 1;
        this.setContentType("text/html");
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public String getParameter(String parameter) {
        return this.request.getParameter(parameter);
    }

    public String getPassword() {
        this.doAuthorization();
        return this.password;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public Map<String, String> getRequestAttributes() {
        return this.map;
    }

    public int getRequestTokenOffset() {
        return this.tokenOffset;
    }

    public String[] getRequestTokens() {
        return this.tokens;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isAuthenticated() {
        this.doAuthorization();
        return this.userName != null;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void printHttpHeader(int size) {
        if (size > 0) {
            this.response.setContentLength(size);
        }
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    private synchronized void doAuthorization() {
        if (this.authDone) {
            return;
        }
        this.authDone = true;
        String auth = this.request.getHeader("Authorization");
        if (auth == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(auth);
        if (st.countTokens() < 2) {
            return;
        }
        if (!st.nextToken().equals("Basic")) {
            return;
        }
        auth = new String(Base64.decode((String)st.nextToken()));
        logger.info("Authentication : >{}<", (Object)auth);
        st = new StringTokenizer(auth, ":");
        if (st.countTokens() < 2) {
            return;
        }
        this.userName = st.nextToken();
        this.password = st.nextToken();
    }
}

