/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd.util;

import com.google.common.collect.ImmutableMap;
import dmg.util.Args;
import dmg.util.HttpResponseEngine;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.dcache.services.httpd.HttpServiceCell;
import org.dcache.services.httpd.handlers.BadConfigHandler;
import org.dcache.services.httpd.handlers.ContextHandler;
import org.dcache.services.httpd.handlers.PathHandler;
import org.dcache.services.httpd.handlers.RedirectHandler;
import org.dcache.services.httpd.handlers.ResponseEngineHandler;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class AliasEntry {
    private static final String[] configClasses = new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.webapp.TagLibConfiguration"};
    public static final String TYPE_FILE = "file";
    public static final String TYPE_DIRECTORY = "directory";
    public static final String TYPE_CONTEXT = "context";
    public static final String TYPE_REDIRECT = "redirect";
    public static final String TYPE_CLASS = "class";
    public static final String TYPE_WEBAPP = "webapp";
    public static final String TYPE_BAD_CONFIG = "badconfig";
    public static final String CELL_ENDPOINT = "serviceCellEndpoint";
    public static final String CELL_NUCLEUS = "serviceCellNucleus";
    public static final String OPT_UNPACK_DIR = "tempUnpackDir";
    private final String name;
    private final AliasType type;
    private final Handler handler;
    private final String spec;
    private String onError;
    private String overwrite;
    private String intFailureMsg;
    private String statusMessage;
    private Method getInfo;

    public static AliasEntry createEntry(Args args, HttpServiceCell cell) throws Exception {
        String alias = args.argv(0);
        String type = args.argv(1);
        String specific = args.argv(2);
        AliasType aliasType = AliasType.fromType(type);
        AliasEntry entry = null;
        AbstractHandler handler = null;
        String failure = null;
        switch (aliasType) {
            case FILE: 
            case DIR: {
                File dir = new File(specific);
                if (!dir.isDirectory() && !dir.isFile()) {
                    throw new Exception("Directory/File not found : " + specific);
                }
                handler = new PathHandler(dir);
                entry = new AliasEntry(alias, aliasType, (Handler)handler, specific);
                entry.statusMessage = alias + " -> " + TYPE_DIRECTORY + "(" + specific + ")";
                break;
            }
            case CONTEXT: {
                handler = new ContextHandler(specific, cell.getDomainContext());
                entry = new AliasEntry(alias, aliasType, (Handler)handler, specific);
                entry.setOnError(args.getOpt("onError"));
                entry.setOverwrite(args.getOpt("overwrite"));
                entry.statusMessage = alias + " -> " + TYPE_CONTEXT + "(" + specific + ")";
                break;
            }
            case REDIRECT: {
                handler = new RedirectHandler(alias, specific);
                entry = new AliasEntry(alias, aliasType, (Handler)handler, specific);
                entry.statusMessage = alias + " -> " + TYPE_REDIRECT + "(" + specific + ")";
                break;
            }
            case ENGINE: {
                int argcount = args.argc() - 3;
                String[] handlerArgs = new String[argcount];
                StringBuilder sb = new StringBuilder();
                sb.append("class=").append(specific);
                for (int i = 0; i < argcount; ++i) {
                    handlerArgs[i] = args.argv(3 + i);
                    sb.append(";").append(handlerArgs[i]);
                }
                ResponseEngineHandler rhandler = new ResponseEngineHandler(specific, handlerArgs);
                try {
                    rhandler.initialize(cell);
                    handler = rhandler;
                }
                catch (Exception e) {
                    handler = new BadConfigHandler();
                    aliasType = AliasType.BADCONFIG;
                    failure = "failed to load class " + specific;
                    sb.append(" FAILED TO LOAD CLASS");
                }
                entry = new AliasEntry(alias, aliasType, (Handler)handler, sb.toString());
                entry.setIntFailureMsg(failure);
                entry.statusMessage = alias + " -> " + TYPE_CLASS + "(" + entry.getSpecificString() + ")";
                break;
            }
            case WEBAPP: {
                String argsstring = args.argv(3);
                Args webappArgs = new Args((CharSequence)argsstring);
                handler = AliasEntry.createWebAppContext(alias, specific, webappArgs, cell);
                entry = new AliasEntry(alias, aliasType, (Handler)handler, args.toString());
                entry.statusMessage = alias + " -> " + TYPE_WEBAPP + "(" + args + ")";
                break;
            }
            case BADCONFIG: {
                handler = new BadConfigHandler();
                entry = new AliasEntry(alias, aliasType, (Handler)handler, specific);
                entry.statusMessage = alias + " -> " + TYPE_BAD_CONFIG + "(" + specific + ")";
                break;
            }
        }
        if (handler instanceof BadConfigHandler && entry != null) {
            ((BadConfigHandler)handler).setFailureMessage(entry.getIntFailureMsg());
        }
        return entry;
    }

    private static Handler createWebAppContext(String alias, String webappsPath, Args args, HttpServiceCell cell) throws Exception {
        String context = "/" + alias;
        String tmp = args.getOpt(OPT_UNPACK_DIR);
        File war = new File(webappsPath, context + ".war");
        File tmpDir = new File(tmp, alias);
        WebAppContext webappContext = new WebAppContext();
        webappContext.setDefaultsDescriptor(cell.getDefaultWebappsXml());
        webappContext.setContextPath(context);
        webappContext.setWar(war.getAbsolutePath());
        webappContext.setExtractWAR(true);
        webappContext.setTempDirectory(tmpDir);
        webappContext.setConfigurationClasses(configClasses);
        new EnvEntry((Object)webappContext, CELL_ENDPOINT, (Object)cell, true);
        new EnvEntry((Object)webappContext, CELL_NUCLEUS, (Object)cell.getNucleus(), true);
        ImmutableMap opts = args.optionsAsMap();
        for (String key : opts.keySet()) {
            new EnvEntry((Object)webappContext, key, opts.get(key), true);
        }
        webappContext.setServer(cell.getServer());
        webappContext.start();
        return webappContext;
    }

    private AliasEntry(String name, AliasType type, Handler handler, String spec) {
        this.name = name;
        this.type = type;
        this.handler = handler;
        this.spec = spec;
        if (handler instanceof ResponseEngineHandler) {
            try {
                HttpResponseEngine engine = ((ResponseEngineHandler)handler).getEngine();
                this.getInfo = engine.getClass().getMethod("getInfo", PrintWriter.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void getInfo(PrintWriter pw) {
        if (this.getInfo == null) {
            pw.println(this.toString());
            return;
        }
        try {
            this.getInfo.invoke((Object)this.handler, pw);
        }
        catch (Exception e) {
            pw.println("Exception : " + e);
        }
    }

    public String getIntFailureMsg() {
        return this.intFailureMsg;
    }

    public String getName() {
        return this.name;
    }

    public String getOnError() {
        return this.onError;
    }

    public String getOverwrite() {
        return this.overwrite;
    }

    public String getSpecificString() {
        return this.spec;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getType() {
        return this.type.toType();
    }

    public void setIntFailureMsg(String entry) {
        this.intFailureMsg = entry;
    }

    public void setOnError(String entry) {
        this.onError = entry;
    }

    public void setOverwrite(String entry) {
        this.overwrite = entry;
    }

    public void shutdown() {
        if (this.handler instanceof ResponseEngineHandler) {
            ((ResponseEngineHandler)this.handler).getEngine().shutdown();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toType()).append("(").append(this.spec).append(")");
        if (this.onError != null) {
            sb.append(" [onError=").append(this.onError).append("]");
        }
        if (this.overwrite != null) {
            sb.append(" [overwrite ").append(this.overwrite).append("]");
        }
        return sb.toString();
    }

    static enum AliasType {
        FILE,
        DIR,
        CONTEXT,
        REDIRECT,
        ENGINE,
        WEBAPP,
        BADCONFIG;


        public static AliasType fromType(String type) throws Exception {
            if (AliasEntry.TYPE_FILE.equalsIgnoreCase(type)) {
                return FILE;
            }
            if (AliasEntry.TYPE_DIRECTORY.equalsIgnoreCase(type)) {
                return DIR;
            }
            if (AliasEntry.TYPE_CONTEXT.equalsIgnoreCase(type)) {
                return CONTEXT;
            }
            if (AliasEntry.TYPE_REDIRECT.equalsIgnoreCase(type)) {
                return REDIRECT;
            }
            if (AliasEntry.TYPE_CLASS.equalsIgnoreCase(type)) {
                return ENGINE;
            }
            if (AliasEntry.TYPE_WEBAPP.equalsIgnoreCase(type)) {
                return WEBAPP;
            }
            if (AliasEntry.TYPE_BAD_CONFIG.equalsIgnoreCase(type)) {
                return BADCONFIG;
            }
            throw new Exception("unknown Alias type: " + type);
        }

        public String toType() {
            switch (this) {
                case FILE: {
                    return AliasEntry.TYPE_FILE;
                }
                case DIR: {
                    return AliasEntry.TYPE_DIRECTORY;
                }
                case CONTEXT: {
                    return AliasEntry.TYPE_CONTEXT;
                }
                case REDIRECT: {
                    return AliasEntry.TYPE_REDIRECT;
                }
                case ENGINE: {
                    return AliasEntry.TYPE_CLASS;
                }
                case WEBAPP: {
                    return AliasEntry.TYPE_WEBAPP;
                }
                case BADCONFIG: {
                    return AliasEntry.TYPE_BAD_CONFIG;
                }
            }
            return "unknown";
        }
    }
}

