/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd.handlers;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import dmg.util.HttpResponseEngine;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dcache.services.httpd.HttpServiceCell;
import org.dcache.services.httpd.util.StandardHttpRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ResponseEngineHandler
extends AbstractHandler {
    private final String className;
    private final String[] args;
    private HttpResponseEngine engine;

    public ResponseEngineHandler(String className, String[] args) {
        this.className = className;
        this.args = args;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Preconditions.checkNotNull((Object)this.engine);
        try {
            StandardHttpRequest proxy = new StandardHttpRequest(request, response);
            this.engine.queryUrl((HttpRequest)proxy);
            proxy.getPrintWriter().flush();
        }
        catch (HttpException e) {
            response.sendError(e.getErrorCode(), e.getMessage());
        }
        catch (URISyntaxException e) {
            response.sendError(500, e.getMessage());
        }
    }

    public HttpResponseEngine getEngine() {
        return this.engine;
    }

    public void initialize(HttpServiceCell cell) throws Exception {
        Class<HttpResponseEngine> c = Class.forName(this.className).asSubclass(HttpResponseEngine.class);
        try {
            Class[] argsClass = new Class[]{CellEndpoint.class, String[].class};
            Constructor<HttpResponseEngine> constr = c.getConstructor(argsClass);
            Object[] args = new Object[]{cell, this.args};
            this.engine = constr.newInstance(args);
        }
        catch (Exception e) {
            try {
                Class[] argsClass = new Class[]{String[].class};
                Constructor<HttpResponseEngine> constr = c.getConstructor(argsClass);
                Object[] args = new Object[]{this.args};
                this.engine = constr.newInstance(args);
            }
            catch (Exception ee) {
                Class[] argsClass = new Class[]{};
                Constructor<HttpResponseEngine> constr = c.getConstructor(argsClass);
                this.engine = constr.newInstance(new Object[0]);
            }
        }
        cell.addCommandListener(this.engine);
        if (this.engine instanceof EnvironmentAware) {
            ((EnvironmentAware)this.engine).setEnvironment(cell.getEnvironment());
        }
        this.engine.startup();
    }
}

