/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd.handlers;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(RedirectHandler.class);
    private final String fromContext;
    private final String toContext;

    public RedirectHandler(String fromContext, String toContext) {
        if ("<home>".equals(fromContext)) {
            fromContext = "/";
        }
        this.fromContext = fromContext;
        this.toContext = toContext;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug("target: {}", (Object)target);
        if (target.contains(this.fromContext)) {
            StringBuilder targetUrl = new StringBuilder(target);
            int i = targetUrl.indexOf(this.fromContext);
            String newUrl = targetUrl.replace(i, i + this.fromContext.length(), this.toContext).toString();
            logger.debug("redirected to: {}", (Object)newUrl);
            response.sendRedirect(newUrl);
        }
    }
}

