/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd.handlers;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dcache.services.httpd.util.StandardHttpRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class PathHandler
extends AbstractHandler {
    private static final FileNameMap mimeTypeMap = URLConnection.getFileNameMap();
    private File path;

    public PathHandler(File path) {
        this.path = path;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            StandardHttpRequest proxy = new StandardHttpRequest(request, response);
            this.sendFile(this.path, proxy);
        }
        catch (Exception t) {
            throw new ServletException("PathHandler failure", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File base, HttpRequest proxy) throws Exception {
        File f;
        String[] tokens = proxy.getRequestTokens();
        String filename = tokens.length < 2 ? "index.html" : Joiner.on((String)"/").join(Iterables.skip(Arrays.asList(tokens), (int)1));
        File file = f = base.isFile() ? base : new File(base, filename);
        if (!f.getCanonicalFile().getAbsolutePath().startsWith(base.getCanonicalFile().getAbsolutePath())) {
            throw new HttpException(403, "Forbidden");
        }
        if (!f.isFile()) {
            throw new HttpException(404, "Not found : " + filename);
        }
        try {
            proxy.setContentType(this.getContentTypeFor(filename));
            Files.copy((File)f, (OutputStream)proxy.getOutputStream());
        }
        finally {
            proxy.getOutputStream().flush();
        }
    }

    private String getContentTypeFor(String fileName) {
        if (fileName.endsWith(".html")) {
            return "text/html";
        }
        if (fileName.endsWith(".css")) {
            return "text/css";
        }
        return mimeTypeMap.getContentTypeFor(fileName);
    }
}

