/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd.handlers;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import dmg.util.HttpBasicAuthenticationException;
import dmg.util.HttpException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dcache.services.httpd.exceptions.OnErrorException;
import org.dcache.services.httpd.util.AliasEntry;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerDelegator
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(HandlerDelegator.class);
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private final Map<String, AliasEntry> aliases;

    private static String extractAlias(String requestURI) {
        return (String)Iterables.getFirst((Iterable)PATH_SPLITTER.split((CharSequence)requestURI), (Object)"<home>");
    }

    private static void handleException(Exception e, String uri, HttpServletResponse response) {
        if (e instanceof ServletException) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpException) {
                HandlerDelegator.printHttpException((HttpException)cause, response);
            }
            logger.warn("Problem with {}: {}", (Object)uri, (Object)e.getMessage());
        } else if (e instanceof HttpException) {
            HandlerDelegator.printHttpException((HttpException)((Object)e), response);
            logger.warn("Problem with {}: {}", (Object)uri, (Object)e.getMessage());
        } else {
            HandlerDelegator.printHttpException(new HttpException(400, "Bad Request : " + e), response);
            logger.warn("Problem in HttpServiceCellHandler: {}", (Throwable)e);
        }
    }

    private static void printHttpException(HttpException exception, HttpServletResponse response) {
        try {
            if (exception instanceof HttpBasicAuthenticationException) {
                String realm = ((HttpBasicAuthenticationException)exception).getRealm();
                response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
            }
            response.sendError(exception.getErrorCode(), exception.getMessage());
        }
        catch (IOException e) {
            logger.warn("Failed to send reply: {}", (Object)e.getMessage());
        }
    }

    public HandlerDelegator(ConcurrentMap<String, AliasEntry> aliases) {
        this.aliases = aliases;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = null;
        AliasEntry entry = null;
        try {
            uri = request.getRequestURI();
            String alias = HandlerDelegator.extractAlias(uri);
            logger.info("handle {}, {}", (Object)uri, (Object)alias);
            entry = this.aliases.get(alias);
            if (entry == null) {
                entry = this.aliases.get("<default>");
            }
            if (entry == null) {
                throw new HttpException(404, "Alias not found : " + alias);
            }
            logger.debug("alias: {}, entry {}", (Object)alias, (Object)entry);
            if (!request.getMethod().equals("GET") && !entry.getType().equals("webapp")) {
                throw new HttpException(501, "Method not implemented: " + request.getMethod());
            }
            String alternate = entry.getOverwrite();
            if (alternate != null) {
                logger.debug("handle, overwritten alias: {}", (Object)alternate);
                AliasEntry overwrittenEntry = this.aliases.get(alternate);
                if (overwrittenEntry != null) {
                    entry = overwrittenEntry;
                }
                logger.debug("handle, alias {}, entry {}", (Object)alternate, (Object)entry);
            }
            Handler handler = entry.getHandler();
            logger.debug("got handler: {}", (Object)handler);
            if (handler != null) {
                handler.handle(target, baseRequest, request, response);
            }
        }
        catch (Exception e) {
            if (entry != null && e.getCause() instanceof OnErrorException) {
                String alternate = entry.getOnError();
                if (alternate != null) {
                    logger.debug("handle, onError alias: {}", (Object)alternate);
                    AliasEntry overwrittenEntry = this.aliases.get(alternate);
                    if (overwrittenEntry != null) {
                        entry = overwrittenEntry;
                        logger.debug("handle, alias {}, entry {}", (Object)alternate, (Object)entry);
                        Handler handler = entry.getHandler();
                        if (handler != null) {
                            try {
                                handler.handle(target, baseRequest, request, response);
                            }
                            catch (ServletException t) {
                                HandlerDelegator.handleException((Exception)((Object)t), uri, response);
                            }
                        }
                    } else {
                        HandlerDelegator.handleException((Exception)((Object)new HttpException(404, "Not found : " + entry.getSpecificString())), uri, response);
                    }
                }
            }
            HandlerDelegator.handleException(e, uri, response);
        }
        logger.info("Finished");
    }
}

