/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd.handlers;

import dmg.util.CollectionFactory;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dcache.services.httpd.exceptions.OnErrorException;
import org.dcache.services.httpd.util.StandardHttpRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ContextHandler
extends AbstractHandler {
    private final String specificName;
    private final Map<String, Object> context;

    public ContextHandler(String specificName, Map<String, Object> context) {
        this.specificName = specificName;
        this.context = context;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String[] tokens;
            StandardHttpRequest proxy = new StandardHttpRequest(request, response);
            Object value = this.specificName.equals("*") ? ((tokens = proxy.getRequestTokens()).length < 2 || tokens[1].equals("index.html") ? this.createContextDirectory() : this.context.get(tokens[1])) : this.context.get(this.specificName);
            if (value == null) {
                throw new OnErrorException();
            }
            String html = String.valueOf(value);
            proxy.getPrintWriter().println(html);
            proxy.getPrintWriter().flush();
        }
        catch (Exception t) {
            throw new ServletException("ContextHandler", (Throwable)t);
        }
    }

    private String createContextDirectory() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><title>Context directory</title>\n");
        sb.append("<body bgcolor=\"#0088dd\">\n");
        sb.append("<h1>Context Directory</h1>\n");
        sb.append("<blockquote>\n");
        sb.append("<center>\n");
        sb.append("<table border=1 cellspacing=0 cellpadding=4 width=\"%90\">\n");
        sb.append("<tr><th>Context Name</th><th>Class</th><th>Content</th></tr>\n");
        SortedMap map = CollectionFactory.newTreeMap();
        map.putAll(this.context);
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            Object o = e.getValue();
            String str = o.toString();
            str = str.substring(0, Math.min(str.length(), 60)).trim();
            str = this.toHtmlEscapedString(str);
            sb.append("<tr><td>").append(key).append("</td><td>").append(o.getClass().getName()).append("</td><td>").append(str.length() == 0 ? "&nbsp;" : str).append("</td></tr>\n");
        }
        sb.append("</table></center>\n");
        sb.append("</blockquote>\n");
        sb.append("<hr>");
        sb.append("<address>Created : ").append(new Date()).append("</address>\n");
        sb.append("</body></html>");
        return sb.toString();
    }

    private String toHtmlEscapedString(String str) {
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

