/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd;

import com.google.common.collect.Maps;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.util.Args;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.Option;
import org.dcache.services.httpd.handlers.HandlerDelegator;
import org.dcache.services.httpd.util.AliasEntry;
import org.dcache.util.Crypto;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceCell
extends AbstractCell
implements EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(HttpServiceCell.class);
    private final ConcurrentMap<String, AliasEntry> aliases = Maps.newConcurrentMap();
    @Option(name="webappsResource", description="Path to the resource URL for webapps default")
    protected String webappResourceUrl;
    @Option(name="authenticated", description="Enablement of secure connection (HTTPS)", defaultValue="false")
    protected Boolean authenticated;
    @Option(name="httpPort", description="Main port for the service")
    protected Integer httpPort;
    @Option(name="maxIdleTime", description="Maximum idle time on connection", unit="ms")
    protected Integer maxIdleTime;
    @Option(name="maxThreads", description="Maximum number of active threads")
    protected Integer maxThreads;
    @Option(name="httpsPort", description="Port for secure access (SSL)")
    protected Integer httpsPort;
    @Option(name="keystore", description="Path to the file containing the encoded server certificate")
    protected String keystore;
    @Option(name="keystoreType", description="Encoding method", defaultValue="PKCS12")
    protected String keystoreType;
    @Option(name="keystorePassword", description="Password for accessing server certificate")
    protected String keystorePassword;
    @Option(name="truststore", description="Path to Java Keystore containing the trusted CA certicates used for SSL")
    protected String truststore;
    @Option(name="truststorePassword", description="Password for accessing trusted CA certs")
    protected String trustPassword;
    @Option(name="httpd.security.ciphers", description="Cipher flags")
    protected String cipherFlags;
    private Server server;
    private String defaultWebappsXml;
    private volatile Map<String, Object> environment = Collections.emptyMap();
    public static final String hh_ls_alias = "[<alias>]";
    public static final String hh_set_alias = "<aliasName> directory|class|context <specification>";
    public static final String fh_set_alias = "set alias <alias>  <type> [<typeSpecific> <...>]\n   <type>             <specific> \n   directory          <fullDirectoryPath>\n   file               <fullFilePath> <arguments> <...>\n   class              <fullClassName> <...>\n   context            [options] <context> or  <contextNameStart>*\n                       options : -overwrite=<alias> -onError=<alias>\n   webapp             <webappsContext> <webappsPath> <tempUnpackDir> <...> \n   redirect           <forward-to-context>\n   predefined alias : <home>    =  default for http://host:port/ \n                      <default> =  default for any type or error \n";
    public static final String hh_unset_alias = "<aliasName>";

    public HttpServiceCell(String name, String args) throws InterruptedException, ExecutionException {
        super(name, args);
        this.doInit();
    }

    public String ac_ls_alias_$_0_1(Args args) throws Exception {
        if (args.argc() == 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry aliasEntry : this.aliases.entrySet()) {
                sb.append((String)aliasEntry.getKey()).append(" -> ").append(aliasEntry.getValue()).append("\n");
            }
            return sb.toString();
        }
        AliasEntry entry = (AliasEntry)this.aliases.get(args.argv(0));
        if (entry == null) {
            throw new Exception("Alias not found : " + args.argv(0));
        }
        return args.argv(0) + " -> " + entry;
    }

    public String ac_set_alias_$_3_16(Args args) throws Exception {
        logger.debug("ac_set_alias_$_3_16 {}", (Object)args.toString());
        AliasEntry entry = AliasEntry.createEntry(args, this);
        logger.debug("putting {}, {}", (Object)entry.getName(), (Object)entry);
        this.aliases.put(entry.getName(), entry);
        return entry.getStatusMessage();
    }

    public String ac_unset_alias_$_1(Args args) {
        this.aliases.remove(args.argv(0));
        return "Done";
    }

    @Override
    public void cleanUp() {
        this.shutDownAliases();
        try {
            if (!this.server.isStopped()) {
                this.server.stop();
            }
            this.server.destroy();
        }
        catch (Exception e) {
            logger.error("Failed to stop Jetty: {}", (Object)e.getMessage());
        }
        super.cleanUp();
    }

    public String getDefaultWebappsXml() {
        return this.defaultWebappsXml;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public void getInfo(PrintWriter pw) {
        for (Map.Entry aliasEntry : this.aliases.entrySet()) {
            pw.println("<<<<< " + (String)aliasEntry.getKey() + " >>>>>>>>>");
            ((AliasEntry)aliasEntry.getValue()).getInfo(pw);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setEnvironment(Map<String, Object> environment) {
        if (environment != null) {
            this.environment = environment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() throws Exception {
        URL url = HttpServiceCell.class.getResource(this.webappResourceUrl);
        this.defaultWebappsXml = url.toExternalForm();
        this.server = new Server(this.httpPort.intValue());
        this.createAndSetThreadPool();
        if (this.authenticated.booleanValue()) {
            this.server.setConnectors(new Connector[]{this.createSimpleConnector(), this.createSslConnector()});
        } else {
            this.server.setConnectors(new Connector[]{this.createSimpleConnector()});
        }
        this.createAndSetHandlers();
        try {
            logger.debug("starting server");
            this.server.start();
        }
        finally {
            if (this.server.isFailed()) {
                logger.error("server failure, calling cleanUp ...");
                this.cleanUp();
            }
        }
    }

    private void createAndSetHandlers() {
        HandlerCollection handlers = new HandlerCollection();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)new HttpdRequestLog());
        handlers.setHandlers(new Handler[]{new HandlerDelegator(this.aliases), new DefaultHandler(), requestLogHandler});
        this.server.setHandler((Handler)handlers);
    }

    private void createAndSetThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(this.maxThreads.intValue());
        this.server.setThreadPool((ThreadPool)threadPool);
    }

    private Connector createSimpleConnector() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.httpPort.intValue());
        connector.setMaxIdleTime(this.maxIdleTime.intValue());
        return connector;
    }

    private Connector createSslConnector() {
        SslSelectChannelConnector connector = new SslSelectChannelConnector();
        connector.setPort(this.httpsPort.intValue());
        connector.setExcludeCipherSuites(Crypto.getBannedCipherSuitesFromConfigurationValue((String)this.cipherFlags));
        SslContextFactory factory = connector.getSslContextFactory();
        factory.setKeyStorePath(this.keystore);
        factory.setKeyStoreType(this.keystoreType);
        factory.setKeyStorePassword(this.keystorePassword);
        factory.setTrustStore(this.truststore);
        factory.setTrustStorePassword(this.trustPassword);
        factory.setWantClientAuth(true);
        factory.setNeedClientAuth(false);
        return connector;
    }

    private void shutDownAliases() {
        for (AliasEntry entry : this.aliases.values()) {
            entry.shutdown();
        }
    }

    private static class HttpdRequestLog
    extends AbstractLifeCycle
    implements RequestLog {
        private HttpdRequestLog() {
        }

        public void log(Request request, Response response) {
            logger.trace("request: {}; response: {}", (Object)request, (Object)response);
        }
    }
}

