/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.hsmcleaner;

import diskCacheV111.vehicles.PoolRemoveFilesFromHSMMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.services.hsmcleaner.PoolInformation;
import org.dcache.services.hsmcleaner.PoolInformationBase;
import org.dcache.services.hsmcleaner.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTracker
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(RequestTracker.class);
    private CellStub _poolStub;
    private Map<String, Timeout> _poolRequests = new HashMap<String, Timeout>();
    private Map<String, Set<URI>> _locationsToDelete = new HashMap<String, Set<URI>>();
    private Sink<URI> _failureSink;
    private Sink<URI> _successSink;
    private int _maxFilesPerRequest = 100;
    private long _timeout = 60000L;
    private Timer _timer = new Timer("Request tracker timeout");
    private PoolInformationBase _pools;
    public static final String hh_requests_ls = "[hsm] # Lists delete requests";

    public synchronized void setPoolStub(CellStub stub) {
        this._poolStub = stub;
    }

    public synchronized void setPoolInformationBase(PoolInformationBase pools) {
        this._pools = pools;
    }

    public synchronized void setMaxFilesPerRequest(int value) {
        this._maxFilesPerRequest = value;
    }

    public synchronized int getMaxFilesPerRequest() {
        return this._maxFilesPerRequest;
    }

    public synchronized void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public synchronized long getTimeout() {
        return this._timeout;
    }

    public synchronized void setSuccessSink(Sink<URI> sink) {
        this._successSink = sink;
    }

    public synchronized void setFailureSink(Sink<URI> sink) {
        this._failureSink = sink;
    }

    public synchronized void submit(URI location) {
        String hsm = location.getAuthority();
        Set<URI> locations = this._locationsToDelete.get(hsm);
        if (locations == null) {
            locations = new HashSet<URI>();
            this._locationsToDelete.put(hsm, locations);
        }
        locations.add(location);
        this.flush(hsm);
    }

    private synchronized void flush(String hsm) {
        PoolInformation pool;
        ArrayList<URI> locations = (ArrayList<URI>)((Object)this._locationsToDelete.get(hsm));
        if (locations == null || locations.isEmpty()) {
            return;
        }
        if (this._poolRequests.containsKey(hsm)) {
            return;
        }
        if (locations.size() > this._maxFilesPerRequest) {
            ArrayList<URI> subset = new ArrayList<URI>(this._maxFilesPerRequest);
            Iterator iterator = locations.iterator();
            for (int i = 0; i < this._maxFilesPerRequest; ++i) {
                subset.add((URI)iterator.next());
            }
            locations = subset;
        }
        while ((pool = this._pools.getPoolWithHSM(hsm)) != null) {
            String name = pool.getName();
            try {
                PoolRemoveFilesFromHSMMessage message = new PoolRemoveFilesFromHSMMessage(name, hsm, locations);
                this._poolStub.send(new CellPath(name), message);
                Timeout timeout = new Timeout(hsm, name);
                this._timer.schedule((TimerTask)timeout, this._timeout);
                this._poolRequests.put(hsm, timeout);
                break;
            }
            catch (NoRouteToCellException e) {
                _log.error("Failed to send message to " + name + ": e.getMessage()");
                this._pools.remove(pool.getName());
            }
        }
        if (pool == null) {
            _log.warn("No pools attached to " + hsm + " are available");
            Iterator<URI> i = this._locationsToDelete.get(hsm).iterator();
            while (i.hasNext()) {
                URI location = i.next();
                assert (location.getAuthority().equals(hsm));
                this._failureSink.push(location);
                i.remove();
            }
        }
    }

    private synchronized void timeout(String hsm, String pool) {
        _log.error("Timeout deleting files on HSM " + hsm + " attached to " + pool);
        this._poolRequests.remove(hsm);
        this._pools.remove(pool);
        this.flush(hsm);
    }

    public synchronized void messageArrived(PoolRemoveFilesFromHSMMessage msg) {
        if (msg.getReturnCode() != 0) {
            _log.error("Received failure from pool: " + msg.getErrorObject());
            return;
        }
        String hsm = msg.getHsm();
        Collection locations = this._locationsToDelete.get(hsm);
        Collection<URI> success = msg.getSucceeded();
        Collection<URI> failures = msg.getFailed();
        if (locations == null) {
            _log.warn("Received confirmation from a pool, for an action this cleaner did not request.");
            return;
        }
        if (!failures.isEmpty()) {
            _log.warn("Failed to delete " + failures.size() + " files from HSM " + hsm + ". Will try again later.");
        }
        for (URI location : success) {
            assert (location.getAuthority().equals(hsm));
            if (!locations.remove(location)) continue;
            this._successSink.push(location);
        }
        for (URI location : failures) {
            assert (location.getAuthority().equals(hsm));
            if (!locations.remove(location)) continue;
            this._failureSink.push(location);
        }
        Timeout timeout = this._poolRequests.remove(hsm);
        if (timeout != null) {
            timeout.cancel();
        }
        this.flush(hsm);
    }

    public synchronized String ac_requests_ls_$_0_1(Args args) {
        StringBuilder sb;
        block4: {
            block3: {
                sb = new StringBuilder();
                if (args.argc() != 0) break block3;
                sb.append(String.format("%-15s %s %s\n", "HSM Instance", "Files", "Pool"));
                for (Map.Entry<String, Set<URI>> e : this._locationsToDelete.entrySet()) {
                    Timeout timeout = this._poolRequests.get(e.getKey());
                    if (timeout == null) {
                        sb.append(String.format("%-15s %5d\n", e.getKey(), e.getValue().size()));
                        continue;
                    }
                    sb.append(String.format("%-15s %5d %s\n", e.getKey(), e.getValue().size(), timeout.getPool()));
                }
                break block4;
            }
            String hsm = args.argv(0);
            Collection locations = this._locationsToDelete.get(hsm);
            if (locations == null) break block4;
            for (URI location : locations) {
                sb.append(location).append('\n');
            }
        }
        return sb.toString();
    }

    public void shutdown() {
        this._timer.cancel();
    }

    class Timeout
    extends TimerTask {
        String _hsm;
        String _pool;

        Timeout(String hsm, String pool) {
            this._hsm = hsm;
            this._pool = pool;
        }

        @Override
        public void run() {
            RequestTracker.this.timeout(this._hsm, this._pool);
        }

        public String getPool() {
            return this._pool;
        }
    }
}

