/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.hsmcleaner;

import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import dmg.util.Args;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.services.hsmcleaner.PoolInformation;

public class PoolInformationBase
implements CellMessageReceiver {
    private long _timeout = 300000L;
    private Map<String, PoolInformation> _pools = new HashMap<String, PoolInformation>();
    private Map<String, Collection<PoolInformation>> _hsmToPool = new HashMap<String, Collection<PoolInformation>>();
    public static final String hh_pools_ls = "# Lists known pools";
    public static final String hh_pools_attached_to_hsm = "<hsm> # Lists pools attached to HSM <hsm>";
    public static final String hh_hsms_attached_to_pool = "<pool> # Lists HSMs attached to pool <pool>";

    public synchronized PoolInformation getPool(String pool) {
        return this._pools.get(pool);
    }

    public synchronized Collection<PoolInformation> getPools() {
        return this._pools.values();
    }

    public synchronized PoolInformation getPoolWithHSM(String hsm) {
        Collection<PoolInformation> pools = this._hsmToPool.get(hsm);
        if (pools != null) {
            for (PoolInformation pool : pools) {
                if (pool.getAge() > this._timeout || pool.isDisabled(8)) continue;
                return pool;
            }
        }
        return null;
    }

    public synchronized void remove(String name) {
        PoolInformation pool = this._pools.remove(name);
        if (pool != null) {
            for (String hsm : pool.getHsmInstances()) {
                Collection<PoolInformation> pools = this._hsmToPool.get(hsm);
                pools.remove(pool);
                if (!pools.isEmpty()) continue;
                this._hsmToPool.remove(hsm);
            }
        }
    }

    public synchronized void messageArrived(PoolManagerPoolUpMessage message) {
        String name = message.getPoolName();
        this.remove(name);
        PoolInformation pool = new PoolInformation(message);
        this._pools.put(name, pool);
        for (String hsm : pool.getHsmInstances()) {
            Collection<PoolInformation> pools = this._hsmToPool.get(hsm);
            if (pools == null) {
                pools = new ArrayList<PoolInformation>();
                this._hsmToPool.put(hsm, pools);
            }
            pools.add(pool);
        }
    }

    public synchronized String ac_pools_ls(Args args) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-20s %s\n", "Pool", "HSM Instances"));
        for (PoolInformation pool : this.getPools()) {
            sb.append(String.format("%-20s %s\n", pool.getName(), pool.getHsmInstances()));
        }
        return sb.toString();
    }

    public synchronized String ac_pools_attached_to_hsm_$_1(Args args) {
        String hsmName = args.argv(0);
        StringBuilder sb = new StringBuilder();
        Collection<PoolInformation> listPools = this._hsmToPool.get(hsmName);
        if (listPools == null || listPools.isEmpty()) {
            sb.append("There are no pools attached to HSM ").append(hsmName);
        } else {
            sb.append("List of pools attached to HSM ").append(hsmName).append(" : \n");
            for (PoolInformation pool : listPools) {
                sb.append("Pool:  ").append(pool.getName()).append("\n");
            }
        }
        return sb.toString();
    }

    public synchronized String ac_hsms_attached_to_pool_$_1(Args args) {
        String poolName = args.argv(0);
        StringBuilder sb = new StringBuilder();
        PoolInformation pool = this.getPool(poolName);
        if (pool == null) {
            sb.append("No information available about pool " + poolName);
        } else {
            Collection<String> listHSMs = pool.getHsmInstances();
            if (listHSMs == null || listHSMs.isEmpty()) {
                sb.append("There are no HSMs attached to pool ").append(poolName);
            } else {
                sb.append("List of HSMs attached to pool ").append(poolName).append(" : \n");
                for (String hsm : listHSMs) {
                    sb.append("HSM:  ").append(hsm).append("\n");
                }
            }
        }
        return sb.toString();
    }
}

