/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.hsmcleaner;

import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import java.util.Collection;
import java.util.Map;

public class PoolInformation {
    private final long _created = System.currentTimeMillis();
    PoolManagerPoolUpMessage _poolup;

    public PoolInformation(PoolManagerPoolUpMessage message) {
        this._poolup = message;
    }

    public String getName() {
        return this._poolup.getPoolName();
    }

    public PoolV2Mode getMode() {
        return this._poolup.getPoolMode();
    }

    public String getMessage() {
        return this._poolup.getMessage();
    }

    public int getCode() {
        return this._poolup.getCode();
    }

    public Collection<String> getHsmInstances() {
        return this._poolup.getHsmInstances();
    }

    public long getAge() {
        return System.currentTimeMillis() - this._created;
    }

    public Map<String, String> getTagMap() {
        return this._poolup.getTagMap();
    }

    public PoolCostInfo getPoolCostInfo() {
        return this._poolup.getPoolCostInfo();
    }

    public boolean isDisabled(int mask) {
        return this._poolup.getPoolMode().isDisabled(mask);
    }

    public boolean isDisabled() {
        PoolV2Mode mode = this.getMode();
        return mode.getMode() == 1 || mode.isDisabled(64) || mode.isDisabled(63);
    }
}

