/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.hsmcleaner;

import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.CellStub;
import org.dcache.cells.Option;
import org.dcache.services.hsmcleaner.EventHistogram;
import org.dcache.services.hsmcleaner.FailureRepository;
import org.dcache.services.hsmcleaner.OSMTrash;
import org.dcache.services.hsmcleaner.PoolInformationBase;
import org.dcache.services.hsmcleaner.RequestTracker;
import org.dcache.services.hsmcleaner.Sink;
import org.dcache.services.hsmcleaner.Trash;
import org.dcache.util.BroadcastRegistrationTask;

public class HSMCleaner
extends AbstractCell {
    private static final long BROADCAST_REGISTRATION_PERIOD = TimeUnit.MINUTES.toMillis(5L);
    private static final long BROADCAST_REGISTRATION_EXPIRATION = TimeUnit.MINUTES.toMillis(6L);
    private final EventHistogram _histogram = new EventHistogram(12, 3600000L);
    private FailureRepository _failures;
    private Trash _trash;
    private RequestTracker _requests;
    private ScheduledExecutorService _executor;
    private BroadcastRegistrationTask _broadcastRegistration;
    private PoolInformationBase _pools;
    private static final Class<?> POOLUP_MESSAGE = PoolManagerPoolUpMessage.class;
    private final Runnable _scanTask = new Runnable(){

        @Override
        public void run() {
            HSMCleaner.this.scan();
        }
    };
    private final Runnable _recoverTask = new Runnable(){

        @Override
        public void run() {
            HSMCleaner.this.recover();
        }
    };
    private final Runnable _flushTask = new Runnable(){

        @Override
        public void run() {
            HSMCleaner.this.flush();
        }
    };
    private Semaphore _limit;
    @Option(name="hsmCleanerScan", description="Scan interval", required=true, unit="seconds")
    protected int _scanInterval;
    @Option(name="hsmCleanerRecover", description="Recover interval", required=true, unit="seconds")
    protected int _recoverInterval;
    @Option(name="hsmCleanerFlush", description="Flush interval", required=true, unit="seconds")
    protected int _flushInterval;
    @Option(name="hsmCleanerTrash", description="Trash directory", required=true)
    protected File _trashLocation;
    @Option(name="hsmCleanerRepository", description="Repository directory", required=true)
    protected File _failureLocation;
    @Option(name="hsmCleanerQueue", description="Max. number of queued files", required=true)
    protected int _maxQueueLength;
    @Option(name="hsmCleanerTimeout", description="Time after which a pool request is considered failed", required=true, unit="seconds")
    protected int _timeout;
    @Option(name="hsmCleanerRequest", description="Max. files per pool request", required=true, unit="files")
    protected int _maxRequests;
    public static final String hh_scan = "# Trigger scan of the trash directory";
    public static final String hh_recover = "# Trigger recovery from failures";
    public static final String hh_flush = "# Force information about failures to stable storage";

    public HSMCleaner(String cellName, String args) throws InterruptedException, ExecutionException {
        super(cellName, args);
        this.doInit();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.useInterpreter(true);
        if (!this._trashLocation.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + this._trashLocation);
        }
        this._failureLocation.mkdirs();
        if (!this._failureLocation.isDirectory()) {
            throw new IOException("Cannot create: " + this._failureLocation);
        }
        CellPath me = new CellPath(this.getCellName(), this.getCellDomainName());
        this._broadcastRegistration = new BroadcastRegistrationTask((CellEndpoint)this, POOLUP_MESSAGE, me);
        this._broadcastRegistration.setExpires(BROADCAST_REGISTRATION_EXPIRATION);
        this._trash = new OSMTrash(this._trashLocation);
        this._requests = new RequestTracker();
        this._failures = new FailureRepository(this._failureLocation);
        this._limit = new Semaphore(this._maxQueueLength);
        this._pools = new PoolInformationBase();
        this._requests.setPoolStub(new CellStub((CellEndpoint)this));
        this._requests.setMaxFilesPerRequest(this._maxRequests);
        this._requests.setTimeout(this._timeout * 1000);
        this._requests.setPoolInformationBase(this._pools);
        this._requests.setSuccessSink(new Sink<URI>(){

            @Override
            public void push(URI uri) {
                HSMCleaner.this.onSuccess(uri);
            }
        });
        this._requests.setFailureSink(new Sink<URI>(){

            @Override
            public void push(URI uri) {
                HSMCleaner.this.onFailure(uri);
            }
        });
        this.addMessageListener(this._pools);
        this.addCommandListener(this._pools);
        this.addMessageListener(this._requests);
        this.addCommandListener(this._requests);
        this._executor = Executors.newSingleThreadScheduledExecutor();
        this._executor.scheduleWithFixedDelay(this._scanTask, this._scanInterval, this._scanInterval, TimeUnit.SECONDS);
        this._executor.scheduleWithFixedDelay(this._recoverTask, this._recoverInterval, this._recoverInterval, TimeUnit.SECONDS);
        this._executor.scheduleWithFixedDelay(this._flushTask, this._flushInterval, this._flushInterval, TimeUnit.SECONDS);
        this._executor.scheduleAtFixedRate(this._broadcastRegistration, 0L, BROADCAST_REGISTRATION_PERIOD, TimeUnit.MILLISECONDS);
    }

    @Override
    public void cleanUp() {
        if (this._requests != null) {
            this._requests.shutdown();
        }
        if (this._executor != null) {
            this._executor.shutdownNow();
        }
        if (this._broadcastRegistration != null) {
            this._broadcastRegistration.unregister();
        }
        super.cleanUp();
    }

    public void getInfo(PrintWriter out) {
        super.getInfo(out);
        this.writeOptions(out);
        out.println("Histogram:");
        this._histogram.write(out);
    }

    protected void scan() {
        try {
            this.info("Scanning " + this._trashLocation);
            this._trash.scan(new Sink<URI>(){

                @Override
                public void push(URI uri) {
                    HSMCleaner.this.onScan(uri);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void recover() {
        try {
            this._failures.recover(new Sink<URI>(){

                @Override
                public void push(URI uri) {
                    HSMCleaner.this.onRecover(uri);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException | IllegalStateException e) {
            this.error(e.getMessage());
        }
    }

    protected void flush() {
        try {
            this._failures.flush(new Sink<URI>(){

                @Override
                public void push(URI uri) {
                    HSMCleaner.this.onQuarantine(uri);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.error(e.getMessage());
        }
    }

    protected void onScan(URI uri) {
        try {
            this.debug("Detected " + uri);
            this._limit.acquire();
            this._requests.submit(uri);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void onSuccess(URI uri) {
        this.debug("Deleted " + uri);
        this._limit.release();
        this._trash.remove(uri);
        this._failures.remove(uri);
        this._histogram.add();
    }

    protected void onFailure(URI uri) {
        this.debug("Failed " + uri);
        this._limit.release();
        this._failures.add(uri);
    }

    protected void onQuarantine(URI uri) {
        this.debug("Flushed " + uri);
        this._trash.remove(uri);
    }

    protected void onRecover(URI uri) {
        try {
            this.debug("Retrying " + uri);
            this._limit.acquire();
            this._requests.submit(uri);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String ac_scan(Args args) {
        this._executor.submit(this._scanTask);
        return "";
    }

    public String ac_recover(Args args) {
        this._executor.submit(this._recoverTask);
        return "";
    }

    public String ac_flush(Args args) {
        this._executor.submit(this._flushTask);
        return "";
    }
}

