/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.hsmcleaner;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.dcache.services.hsmcleaner.PatternFilenameFilter;
import org.dcache.services.hsmcleaner.Sink;

public class FailureRepository {
    protected final File _directory;
    protected Set<URI> _locations = new HashSet<URI>();
    protected final Set<URI> _recovering = new HashSet<URI>();
    protected PrintStream _out;
    protected static final FilenameFilter temporaryFiles = new PatternFilenameFilter("flushing-.+\\.tmp");
    protected static final FilenameFilter failureFiles = new PatternFilenameFilter("failed-.+");

    public FailureRepository(File directory) {
        this._directory = directory;
        for (File f : this._directory.listFiles(temporaryFiles)) {
            f.delete();
        }
    }

    protected void renameToUniqueName(File file) throws IOException {
        File newName = File.createTempFile("failed-", "", this._directory);
        if (!newName.delete()) {
            throw new IOException("Cannot delete " + newName);
        }
        if (!file.renameTo(newName)) {
            throw new IOException("Failed to rename " + file);
        }
    }

    protected File createFlushFile() throws IOException {
        return File.createTempFile("flushing-", ".tmp", this._directory);
    }

    public synchronized void add(URI location) {
        if (this._recovering.remove(location)) {
            this._out.println(location);
            if (this._recovering.isEmpty()) {
                this.notifyAll();
            }
        } else {
            this._locations.add(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Sink<URI> sink) throws FileNotFoundException, IOException, InterruptedException {
        Set<URI> locations;
        FailureRepository failureRepository = this;
        synchronized (failureRepository) {
            if (this._locations.isEmpty()) {
                return;
            }
            locations = this._locations;
            this._locations = new HashSet<URI>();
        }
        try {
            File tmpFile = this.createFlushFile();
            try (FileOutputStream os = new FileOutputStream(tmpFile);){
                PrintStream out = new PrintStream(new BufferedOutputStream(os));
                for (URI location : locations) {
                    out.println(location);
                }
                if (out.checkError()) {
                    throw new IOException("Could not write to " + tmpFile);
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                os.getFD().sync();
                os.close();
                this.renameToUniqueName(tmpFile);
                for (URI location : locations) {
                    sink.push(location);
                }
                locations.clear();
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Failed to create file " + tmpFile + ": " + e.getMessage());
            }
            finally {
                tmpFile.delete();
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to flush failure repository: " + e.getMessage());
        }
        finally {
            FailureRepository failureRepository2 = this;
            synchronized (failureRepository2) {
                this._locations.addAll(locations);
            }
        }
    }

    public synchronized void remove(URI location) {
        this._recovering.remove(location);
        if (this._recovering.isEmpty()) {
            this.notifyAll();
        }
    }

    private synchronized void addToRecoverySet(URI location) {
        this._recovering.add(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(Sink<URI> sink) throws InterruptedException, FileNotFoundException, IOException {
        File tmpFile = this.createFlushFile();
        try {
            FileOutputStream os = new FileOutputStream(tmpFile);
            FailureRepository failureRepository = this;
            synchronized (failureRepository) {
                if (this._out != null) {
                    throw new IllegalStateException("Concurrent calls detected");
                }
                this._out = new PrintStream(new BufferedOutputStream(os));
            }
            try {
                File[] inFiles;
                for (File file : inFiles = this._directory.listFiles(failureFiles)) {
                    try (BufferedReader in = new BufferedReader(new FileReader(file));){
                        String s;
                        while ((s = in.readLine()) != null) {
                            try {
                                URI location = new URI(s);
                                this.addToRecoverySet(location);
                                sink.push(location);
                            }
                            catch (URISyntaxException e) {
                                throw new IOException("Failed to parse '" + s + "' in " + file + ": " + e.getMessage());
                            }
                            if (!Thread.interrupted()) continue;
                            throw new InterruptedException();
                        }
                    }
                }
                FailureRepository failureRepository2 = this;
                synchronized (failureRepository2) {
                    while (!this._recovering.isEmpty()) {
                        this.wait();
                    }
                    if (this._out.checkError()) {
                        throw new IOException("Could not write to " + tmpFile);
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    os.getFD().sync();
                    os.close();
                }
                this.renameToUniqueName(tmpFile);
                for (File file : inFiles) {
                    file.delete();
                }
            }
            finally {
                os.close();
                failureRepository = this;
                synchronized (failureRepository) {
                    this._out = null;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("Failed to create file " + tmpFile + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("Failed to flush failure repository: " + e.getMessage());
        }
        finally {
            tmpFile.delete();
        }
    }
}

